/**
 * Name: system_reboot_test.c
 * Desc: Test writing to SYSTEM_REBOOT.
 * Note: LJM 1.0705 - USB T7 / LJM connection fails
 *       Works fine via Ethernet.
**/

#include <stdio.h>
#include <string.h>

#include "LabJackM.h"

#include "../LJM_Utilities.h"

int main()
{
	int err;
	int handle;
    int counter;
    double val;

	EnableLoggingLevel(LJM_TRACE);

	handle = OpenOrDie(LJM_dtANY, LJM_ctUSB, "LJM_idANY");

	PrintDeviceInfoFromHandle(handle);

	GetAndPrint(handle, "AIN0");

	printf("SYSTEM_REBOOT\n");
	WriteNameOrDie(handle, "SYSTEM_REBOOT", 0x4C4A0000);

    for (counter = 0; counter < 20; counter++) {
        printf(" . ");
        fflush(stdout);
        MillisecondSleep(100); // LJM 1.0705: 2200 ms or less kills it
        // MillisecondSleep(2300); // LJM 1.0705: 2300 ms or greater is fine

        err = LJM_eReadName(handle, "AIN0", &val);
        PrintErrorIfError(err, "AIN0");
        if (err == LJME_NOERROR) {
	        printf("AIN0: %f\n", val);
	    }
    }

	err = LJM_Close(handle);
	ErrorCheck(err, "LJM_Close");

	WaitForUserIfWindows();

	return LJME_NOERROR;
}
