Attribute VB_Name = "LabJackM_VB"
'
' The LJM library function calls for VB6/VBA. Note that not all LJM functions and constants have been
' declared here. For a list of the the library functions and constants check the LabJackM.h header
' and add the functions you need.
'
' The provided LJM_eWriteNames, LJM_eReadNames, LJM_eNames and LJM_NamesToAddresses are not direct
' calls to the LJM dll functions with the same name due to the functions having C array of strings
' (char **) parameters which are not supported in VBA/VB6. They have been reimplemented for VB6/VBA
' compatibility.
'
Global Const LabJackM_VB_Version = 1.0701 'LJM library last tested with


'Read/Write direction constants:
Global Const LJM_READ = 0
Global Const LJM_WRITE = 1

'Data Types:
Global Const LJM_UINT16 = 0  'C type of unsigned short
Global Const LJM_UINT32 = 1  'C type of unsigned int
Global Const LJM_INT32 = 2  'C type of int
Global Const LJM_FLOAT32 = 3  'C type of float

'Advanced users data types:
'     These do not do any endianness conversion.
Global Const LJM_BYTE = 99
Global Const LJM_STRING = 98

Global Const LJM_STRING_MAX_SIZE = 49
Global Const LJM_STRING_ALLOCATION_SIZE = 50

Global Const LJM_INVALID_NAME_ADDRESS = -1

Global Const LJM_MAX_NAME_SIZE = 256

Global Const LJM_MAC_STRING_SIZE = 18

Global Const LJM_IPv4_STRING_SIZE = 16

Global Const LJM_BYTES_PER_REGISTER = 2

'Device types:
Global Const LJM_dtANY = 0
Global Const LJM_dtUE9 = 9
Global Const LJM_dtU3 = 3
Global Const LJM_dtU6 = 6
Global Const LJM_dtT7 = 7
Global Const LJM_dtSKYMOTE_BRIDGE = 1000
Global Const LJM_dtDIGIT = 200

'Connection types:
Global Const LJM_ctANY = 0
Global Const LJM_ctUSB = 1
Global Const LJM_ctTCP = 2
Global Const LJM_ctETHERNET = 3
Global Const LJM_ctWIFI = 4

'TCP/Ethernet constants:
Global Const LJM_NO_IP_ADDRESS = 0
Global Const LJM_NO_PORT = 0
Global Const LJM_DEFAULT_PORT = 502

'Identifier types:
Global Const LJM_DEMO_MODE = "-1"
Global Const LJM_idANY = 0

'LJM_AddressesToMBFB Constants
Global Const LJM_DEFAULT_FEEDBACK_ALLOCATION_SIZE = 62
Global Const LJM_USE_DEFAULT_MAXBYTESPERMBFB = 0

'LJM_MBFBComm Constants
Global Const LJM_DEFAULT_UNIT_ID = 1

'LJM_ListAll Constants
Global Const LJM_LIST_ALL_SIZE = 128

Global Const LJM_MAX_USB_PACKET_NUM_BYTES = 64
Global Const LJM_MAX_TCP_PACKET_NUM_BYTES_T7 = 1040
Global Const LJM_MAX_TCP_PACKET_NUM_BYTES_NON_T7 = 64 'This may change

'Timeout Constants
Global Const LJM_NO_TIMEOUT = 0
Global Const LJM_DEFAULT_TIMEOUT = 20000 ' Send/Receive timeout in milliseconds

'Stream Constants
Global Const LJM_DUMMY_VALUE = -9999
Global Const LJM_SCAN_NOT_READ = -8888
Global Const LJM_GND = 199

Global Const LJME_NOERROR = 0
Global Const LJME_UNKNOWN_ERROR = 1221


'A signed 32-bit integer is called a Long in VBA, so LJM calls with an int are a long here.

Declare Function LJM_ListAllS Lib "labjackm.dll" (ByVal DeviceType As String, ByVal ConnectionType As String, ByRef NumFound As Long, ByRef aDeviceTypes As Long, ByRef aConnectionTypes As Long, ByRef aSerialNumbers As Long, ByRef aIPAddresses As Long) As Long

Declare Function LJM_OpenS Lib "labjackm.dll" (ByVal DeviceType As String, ByVal ConnectionType As String, ByVal Identifier As String, ByRef Handle As Long) As Long

Declare Function LJM_GetHandleInfo Lib "labjackm.dll" (ByVal Handle As Long, ByRef DeviceType As Long, ByRef ConnectionType As Long, ByRef SerialNumber As Long, ByRef IPAddress As Long, ByRef port As Long, ByRef maxBytesPerMB As Long) As Long

Declare Function LJM_Close Lib "labjackm.dll" (ByVal Handle As Long) As Long
Declare Function LJM_CloseAll Lib "labjackm.dll" () As Long

'Renamed Type parameter to DataType
Declare Function LJM_eWriteAddress Lib "labjackm.dll" (ByVal Handle As Long, ByVal Address As Long, ByVal DataType As Long, ByVal Value As Double) As Long

'Renamed Type parameter to DataType
Declare Function LJM_eReadAddress Lib "labjackm.dll" (ByVal Handle As Long, ByVal Address As Long, ByVal DataType As Long, ByRef Value As Double) As Long

Declare Function LJM_eWriteName Lib "labjackm.dll" (ByVal Handle As Long, ByVal Name As String, ByVal Value As Double) As Long

Declare Function LJM_eReadName Lib "labjackm.dll" (ByVal Handle As Long, ByVal Name As String, ByRef Value As Double) As Long

'Renamed aTypes parameter to aDataTypes
Declare Function LJM_eWriteAddresses Lib "labjackm.dll" (ByVal Handle As Long, ByVal NumFrames As Long, ByRef aAddresses As Long, ByRef aDataTypes As Long, ByRef aValues As Double, ByRef ErrorAddress As Long) As Long

'Renamed aTypes parameter to aDataTypes
Declare Function LJM_eReadAddresses Lib "labjackm.dll" (ByVal Handle As Long, ByVal NumFrames As Long, ByRef aAddresses As Long, ByRef aDataTypes As Long, ByRef aValues As Double, ByRef ErrorAddress As Long) As Long

'Renamed aTypes parameter to aDataTypes
Declare Function LJM_eAddresses Lib "labjackm.dll" (ByVal Handle As Long, ByVal NumFrames As Long, ByRef aAddresses As Long, ByRef aDataTypes As Long, ByRef aWrites As Long, ByRef aNumValues As Long, ByRef aValues As Double, ByRef ErrorAddress As Long) As Long

Declare Function LJM_eStreamStart Lib "labjackm.dll" (ByVal Handle As Long, ByVal ScansPerRead As Long, ByVal NumAddresses As Long, ByRef aScanList As Long, ByRef ScanRate As Double) As Long
    
Declare Function LJM_eStreamRead Lib "labjackm.dll" (ByVal Handle As Long, ByRef aData As Double, ByRef DeviceScanBacklog As Long, ByRef LJMScanBacklog As Long) As Long
    
Declare Function LJM_eStreamStop Lib "labjackm.dll" (ByVal Handle As Long) As Long

'The string must be initialized to 256 bytes.
'Note that Strings are passed ByVal in VBA.  Also, functions
'with no return value are called a "Sub" in VB rather than
'a "Function", and when you call a "Sub" you don't put
'parentheses around the parameters.
Declare Sub LJM_ErrorToString Lib "labjackm.dll" (ByVal ErrorCode As Long, ByVal ErrorString As String)

Declare Function LJM_NumberToIP Lib "labjackm.dll" (ByVal Number As Long, ByVal IPv4String As String) As Long

Declare Function LJM_ReadLibraryConfigS Lib "labjackm.dll" (ByVal Parameter As String, ByRef Value As Double) As Long

'Renamed Type parameter to DataType
Declare Function LJM_NameToAddress Lib "labjackm.dll" (ByVal Name As String, ByRef Address As Long, ByRef DataType As Long) As Long

'Renamed aTypes parameter to aDataTypes
Function LJM_NamesToAddresses(ByVal NumFrames As Long, ByRef aNames() As String, ByRef aAddresses() As Long, ByRef aDataTypes() As Long) As Long
    Dim lngAddress As Long
    Dim lngDataType As Long
    Dim i As Long 'Index of aNames
    Dim fiN As Long 'First index of aNames
    Dim iA As Long 'Index of aAddresses
    
    fiN = LBound(aNames)
    iA = LBound(aAddresses)
    
    For i = fiN To fiN + NumFrames - 1
        LJM_NamesToAddresses = LJM_NameToAddress(aNames(i), lngAddress, lngDataType)
        aAddresses(iA) = lngAddress
        aDataTypes(iA) = lngDataType
        If LJM_NamesToAddresses <> LJME_NOERROR Then
            Exit Function
        End If
        iA = iA + 1
    Next i
End Function
    
Function LJM_eWriteNames(ByVal Handle As Long, ByVal NumFrames As Long, ByRef aNames() As String, ByRef aValues() As Double, ByRef ErrorAddress As Long) As Long
    Dim lngWrites(0) As Long
    Dim lngNumValues(0) As Long
    LJM_eWriteNames = LJM_eWRNames(0, Handle, NumFrames, aNames, lngWrites, lngNumValues, aValues, ErrorAddress)
End Function

Function LJM_eReadNames(ByVal Handle As Long, ByVal NumFrames As Long, ByRef aNames() As String, ByRef aValues() As Double, ByRef ErrorAddress As Long) As Long
    Dim lngWrites(0) As Long
    Dim lngNumValues(0) As Long
    LJM_eReadNames = LJM_eWRNames(1, Handle, NumFrames, aNames, lngWrites, lngNumValues, aValues, ErrorAddress)
End Function

Function LJM_eNames(ByVal Handle As Long, ByVal NumFrames As Long, ByRef aNames() As String, ByRef aWrites() As Long, ByRef aNumValues() As Long, ByRef aValues() As Double, ByRef ErrorAddress As Long) As Long
    LJM_eNames = LJM_eWRNames(2, Handle, NumFrames, aNames, aWrites, aNumValues, aValues, ErrorAddress)
End Function


'Private functions.

'Used by VBA/VB6 implementations of LJM_eWriteNames, LJM_eReadNames and LJM_eNames.
'modes: 0 = eWriteNames, 1 = eReadNames, 2 = eNames
Private Function LJM_eWRNames(ByVal mode As Long, ByVal Handle As Long, ByVal NumFrames As Long, ByRef aNames() As String, ByRef aWrites() As Long, ByRef aNumValues() As Long, ByRef aValues() As Double, ByRef ErrorAddress As Long) As Long
    Dim lngAddresses() As Long
    Dim lngDataTypes() As Long
    'First indexes of arrays
    Dim fiAddr As Long
    Dim fiWrites As Long
    Dim fiNVals As Long
    Dim fiVals As Long
    
    fiWrites = LBound(aWrites)
    fiNVals = LBound(aNumValues)
    fiVals = LBound(aValues)
    
    ReDim lngAddresses(NumFrames - 1)
    ReDim lngDataTypes(NumFrames - 1)
    
    fiAddr = LBound(lngAddresses)
    
    LJM_eWRNames = LJM_NamesToAddresses(NumFrames, aNames, lngAddresses, lngDataTypes)
    If LJM_eWRNames <> LJME_NOERROR Then
        Erase lngAddresses, lngDataTypes
        Exit Function
    End If
    
    If mode = 0 Then
        LJM_eWRNames = LJM_eWriteAddresses(Handle, NumFrames, lngAddresses(fiAddr), lngDataTypes(fiAddr), aValues(fiVals), ErrorAddress)
    ElseIf mode = 1 Then
        LJM_eWRNames = LJM_eReadAddresses(Handle, NumFrames, lngAddresses(fiAddr), lngDataTypes(fiAddr), aValues(fiVals), ErrorAddress)
    ElseIf mode = 2 Then
        LJM_eWRNames = LJM_eAddresses(Handle, NumFrames, lngAddresses(fiAddr), lngDataTypes(fiAddr), aWrites(fiWrites), aNumValues(fiNVals), aValues(fiVals), ErrorAddress)
    Else
        'Shouldn't be here
        LJM_eWRNames = LJME_UNKNOWN_ERROR
    End If
    Erase lngAddresses, lngDataTypes
End Function
