/***
Demonstrates configuring and reading a single analog input (AIN) with a LabJack.

 ***/
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.labjack.LJM;
import com.labjack.LJMException;

public class SingleAINWithConfig {

	public static void main(final String[] args) {
		try {
			IntByReference handleRef = new IntByReference(0);
			int handle = 0;

			//Open first found LabJack
			LJM.openS("ANY", "ANY", "ANY", handleRef);
			//LJM.open(LJM.Constants.dtANY, LJM.Constants.ctANY, "ANY", handleRef);
			handle = handleRef.getValue();

			LJMUtilities.printDeviceInfo(handle);

			//Setup and call eWriteNames to configure the AIN on the LabJack.
			String[] aNames = { "AIN0_NEGATIVE_CH", "AIN0_RANGE",
					"AIN0_RESOLUTION_INDEX" };
			double[] aValues = { 199, 10, 0 };
			int numFrames = aNames.length;
			IntByReference errAddr = new IntByReference(-1);
			LJM.eWriteNames(handle, numFrames, aNames, aValues, errAddr);

			System.out.println("\nSet configuration:");
			for (int i = 0; i < numFrames; i++) {
				System.out.println("    " + aNames[i] + " : " + aValues[i]
						+ " ");
			}

			//Setup and call eReadName to read an AIN from the LabJack.
			String name = "AIN0";
			DoubleByReference valueRef = new DoubleByReference(0);
			LJM.eReadName(handle, name, valueRef);

			System.out.println("\n" + name + " reading : "
					+ String.format("%.4f", valueRef.getValue()) + " V");

			//Close handle
			LJM.close(handle);
		} catch (LJMException le) {
			le.printStackTrace();
			LJM.closeAll();
		}
	}
}