/***
Demonstrates how to read the device name string from a LabJack.

 ***/
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.Pointer;
import com.sun.jna.Memory;
import com.labjack.LJM;
import com.labjack.LJMException;

public class ReadDeviceNameString {

	public static void main(final String[] args) {
		try {
			IntByReference handleRef = new IntByReference(0);
			int handle = 0;

			//Open first found LabJack
			LJM.openS("ANY", "ANY", "ANY", handleRef);
			//LJM.open(LJM.Constants.dtANY, LJM.Constants.ctANY, "ANY", handleRef);
			handle = handleRef.getValue();

			LJMUtilities.printDeviceInfo(handle);

			//Call eReadNameString to read the name string from the LabJack.
			Pointer strPtr = new Memory(LJM.Constants.STRING_ALLOCATION_SIZE);
			String str = "";
			LJM.eReadNameString(handle, "DEVICE_NAME_DEFAULT", strPtr);

			System.out.println("\nDevice name : " + strPtr.getString(0));

			//Close handle
			LJM.close(handle);
		}
		catch (LJMException le) {
			le.printStackTrace();
			LJM.closeAll();
		}
	}
}