/***
Demonstrates how to read configuration settings on a LabJack.

 ***/
import com.sun.jna.ptr.IntByReference;
import com.labjack.LJM;
import com.labjack.LJMException;

public class ReadConfig {

	public static void main(final String[] args) {
		try {
			IntByReference handleRef = new IntByReference(0);
			int handle = 0;

			//Open first found LabJack
			LJM.openS("ANY", "ANY", "ANY", handleRef);
			//LJM.open(LJM.Constants.dtANY, LJM.Constants.ctANY, "ANY", handleRef);
			handle = handleRef.getValue();

			LJMUtilities.printDeviceInfo(handle);

			//Setup and call eReadNames to read config. values from the LabJack.
			String[] aNames = {"PRODUCT_ID", "HARDWARE_VERSION",
					"FIRMWARE_VERSION", "BOOTLOADER_VERSION",
					"WIFI_VERSION", "SERIAL_NUMBER",
					"POWER_ETHERNET_DEFAULT", "POWER_WIFI_DEFAULT",
					"POWER_AIN_DEFAULT", "POWER_LED_DEFAULT"};
			double[] aValues = new double[aNames.length];
			int numFrames = aNames.length;
			IntByReference errAddr = new IntByReference(-1);
			LJM.eReadNames(handle, numFrames, aNames, aValues, errAddr);

			System.out.println("\nConfiguration settings:");
			for(int i = 0; i < numFrames; i++) {
				System.out.println("    " + aNames[i] + " : "
						+ String.format("%.4f", aValues[i]));
			}

			//Close handle
			LJM.close(handle);
		}
		catch (LJMException le) {
			le.printStackTrace();
			LJM.closeAll();
		}
	}
}