/***
Demonstrates how to read the ethernet MAC from a LabJack.

 ***/
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.Pointer;
import com.sun.jna.Memory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import com.labjack.LJM;
import com.labjack.LJMException;

public class ReadEthernetMac {

	public static void main(final String[] args) {
		try {
			IntByReference handleRef = new IntByReference(0);
			int handle = 0;

			//Open first found LabJack
			LJM.openS("ANY", "ANY", "ANY", handleRef);
			//LJM.open(LJM.Constants.dtANY, LJM.Constants.ctANY, "ANY", handleRef);
			handle = handleRef.getValue();

			LJMUtilities.printDeviceInfo(handle);

			//Call eAddresses to read the ethernet MAC from the LabJack. Note
			//that we are reading a byte array which is the big endian binary
			//representation of the 64-bit MAC.
			int numFrames = 1;
			int[] aAddresses = {60020};
			int[] aTypes = {LJM.Constants.BYTE};
			int[] aWrites = {LJM.Constants.READ};
			int[] aNumValues = {8};
			double[] aValues = new double[8];
			IntByReference errAddrRef = new IntByReference(-1);
			LJM.eAddresses(handle, numFrames, aAddresses, aTypes, aWrites,
					aNumValues, aValues, errAddrRef);

			//Convert returned values to bytes.
			byte[] macBytes = new byte[8];
			for(int i = 0; i < 8; i++) {
				macBytes[i] = (byte)(new Double(aValues[i]).longValue() & 0xFF);
			}

			//Convert big endian byte array to a 64-bit unsigned integer value.
			ByteBuffer bb = ByteBuffer.wrap(macBytes);
			bb.order(ByteOrder.BIG_ENDIAN);
			long macNumber = bb.getLong();

			//Convert the MAC value/number to its string representation.
			Pointer macStringPtr = new Memory(LJM.Constants.MAC_STRING_SIZE);
			LJM.numberToMAC(macNumber, macStringPtr);

			System.out.println("\nEthernet MAC : " + macNumber + " - "
					+ macStringPtr.getString(0));

			//Close handle
			LJM.close(handle);
		}
		catch (LJMException le) {
			le.printStackTrace();
			LJM.closeAll();
		}
	}
}