package com.teravation.labjack;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * This file is part of LabJackJava.  Copyright 2003-2004, Teravation.  All rights reserved. 
 * 
 * LabJackJava is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * LabJackJava is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with LabJackJava;
 * if not, write to:
 *    Free Software Foundation, Inc.
 *    59 Temple Place, Suite 330
 *    Boston, MA  02111-1307  USA
 * 
 * In addition, as a special exception, Teravation gives permission to link the code of this program with
 * the LabJack C driver (or with modified versions of the LabJack C driver that use the same license),
 * and distribute linked combinations including the two.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the LabJack C driver.  If you modify this file, you may 
 * extend this exception to your version of the file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 */

/**
 * This is the standard exception thrown from all {@link LabJack LabJack} operations.  The <code>errorcode</code>
 * details the type of exception that occurred.  Internationalized error messages are loaded from the appropriate
 * Locale's .properties file.
 *
 * <p />Copyright &copy; 2003-2004 <a href="http://www.teravation.com">Teravation</a>. All rights reserved.
 * 
 * @created (1/17/2003 1:42:17 PM)
 * @version 4.0
 * @author Chris Reigrut 
 */
public class LabJackException extends Exception {
	private int errorCode = 0;
	
	/**
	 * Constructor (empty)
	 *
	 * @created (1/17/2003 1:42:17 PM)
	 */
	public LabJackException() {
		super();
	}
	
	/**
	 * Constructor (takes underlying error code)
	 *
	 * @created (1/17/2003 1:42:17 PM)
	 *
	 * @param errorCode the underlying error code
	 */
	public LabJackException(int errorCode) {
		super();
		this.errorCode = errorCode;
	}
	
	/**
	 * Constructor (takes underlying error message)
	 *
	 * @created (1/17/2003 1:42:17 PM)
	 *
	 * @param errorCode the underlying error message
	 */
	public LabJackException(String s) {
		super(s);
	}
	
	/**
	 * Returns the underlying error code for this exception.
	 *
	 * @created (1/17/2003 1:44:33 PM)
	 *
	 * @return the underlying error code for this exception.
	 */
	public int getErrorCode() {
		return errorCode;
	}
	
	/**
	 * Returns the localized error message string of this exception.
	 *
	 * @created (1/17/2003 1:44:33 PM)
	 *
	 * @return the localized error message for this exception.
	 */
	public String getLocalizedMessage() {
		String message = super.getMessage();
		if (message == null) {
			Locale l = Locale.getDefault();
			ResourceBundle b = ResourceBundle.getBundle("properties/LabJack", l);
			try {
				message = b.getString("errorMessage." + this.getErrorCode());
			} catch (MissingResourceException mre) {
				message = this.getMessage();
			}
		}

		return message;
	}
	
	/**
	 * Returns the error message string of this exception.
	 *
	 * @created (1/17/2003 1:44:33 PM)
	 *
	 * @return the error message for this exception.
	 */
	public String getMessage() {
		String message = super.getMessage();
		if (message == null) {
			message = "Errorcode " + this.getErrorCode();
		}

		return message;
	}
}
