/*
 * Decompiled with CFR 0.152.
 */
package com.teravation.labjack;

import com.teravation.labjack.LabJack;
import com.teravation.labjack.LabJackException;
import com.teravation.labjack.LabJackImpl;
import com.teravation.labjack.LabJackScan;

public class LabJackDriver
extends LabJackImpl
implements LabJack {
    private int pulseB1 = 0;
    private int pulseC1 = 0;
    private int pulseB2 = 0;
    private int pulseC2 = 0;
    private static Class thisClass;
    private static LabJack[] labjacks;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.teravation.labjack.LabJackDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        thisClass = clazz;
        System.loadLibrary("ljackj");
    }

    private LabJackDriver() {
    }

    private LabJackDriver(int localId, int serialNumber, int productId) {
        this();
        this.setLocalId(localId);
        this.setSerialNumber(serialNumber);
        this.setProductId(productId);
    }

    private native float[] apiAISample(int var1, long var2, long var4, long var6, long var8, long[] var10, long[] var11, long var12) throws LabJackException;

    private native float apiAIBurst(int var1, long var2, long var4, long var6, long var8, long[] var10, long[] var11, float var12, long var13, long var15, long var17, long var19, long var21, long var23, LabJackScan var25) throws LabJackException;

    private native long apiAOUpdate(int var1, long var2, long var4, long var6, long var8, long var10, long var12, float var14, float var15) throws LabJackException;

    private native float apiEAnalogIn(int var1, int var2, int var3) throws LabJackException;

    private native void apiEAnalogOut(int var1, float var2, float var3) throws LabJackException;

    private native long apiECount(int var1, boolean var2) throws LabJackException;

    private native boolean apiEDigitalIn(int var1, int var2, boolean var3) throws LabJackException;

    private native void apiEDigitalOut(int var1, int var2, boolean var3, boolean var4) throws LabJackException;

    private static native LabJack[] apiListAll() throws LabJackException;

    private native void apiSHT1X(int var1);

    private native void apiPulseOut(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8) throws LabJackException;

    private native void apiPulseOutStart(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8) throws LabJackException;

    private native void apiPulseOutFinish(int var1, int var2) throws LabJackException;

    private native void apiReEnum(int var1) throws LabJackException;

    private native void apiReset(int var1) throws LabJackException;

    private native float apiGetFirmwareVersion(int var1) throws LabJackException;

    private static native float apiGetDriverVersion() throws LabJackException;

    private native void apiLocalID(int var1, int var2) throws LabJackException;

    private native float apiAIStreamStart(int var1, long var2, long var4, long var6, long var8, long[] var10, long[] var11, float var12, long var13, long var15) throws LabJackException;

    private native void apiAIStreamRead(int var1, long var2, long var4, LabJackScan var6) throws LabJackException;

    private native void apiAIStreamClear(int var1) throws LabJackException;

    static LabJack[] getAll() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            return LabJackDriver.apiListAll();
        }
    }

    static float getDriverVersion() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            return LabJackDriver.apiGetDriverVersion();
        }
    }

    public void updateAI(int channel) throws LabJackException {
        if (channel < 0 || channel >= 8) {
            throw new LabJackException(21);
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            float value;
            this.analogInputValues[channel] = value = this.apiEAnalogIn(this.getSerialNumber(), channel, 0);
        }
    }

    public void updateAll() throws LabJackException {
        this.updateAll(false);
    }

    public void updateAll(boolean resetCounter) throws LabJackException {
        this.updateAllAOsAndDigitals(resetCounter);
        this.updateAllAIs();
        this.updateAllDifferentialAIs();
        this.updateEnvironmentals();
    }

    public void updateAllAIs() throws LabJackException {
        this.updateLowAIs();
        this.updateHighAIs();
    }

    public void updateAllAOsAndDigitals() throws LabJackException {
        this.updateAllAOsAndDigitals(false);
    }

    public void updateAllAOsAndDigitals(boolean resetCounter) throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            long allDIOValues = this.apiAOUpdate(this.getSerialNumber(), this.digitalDDirections, this.digitalIODirections, this.digitalDValues, this.digitalIOValues, 1L, resetCounter ? 1 : 0, this.analogOutputValues[0], this.analogOutputValues[1]);
            this.digitalIOValues = this.digitalIOValues & this.digitalIODirections | (this.digitalIODirections ^ 0xFFFFFFFFFFFFFFFFL) & (allDIOValues & 0xFL);
            this.digitalDValues = this.digitalDValues & this.digitalDDirections | (this.digitalDDirections ^ 0xFFFFFFFFFFFFFFFFL) & allDIOValues >> 4;
        }
    }

    public void updateAllDifferentialAIs() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            long[] channels = new long[]{8L, 9L, 10L, 11L};
            float[] voltages = this.apiAISample(this.getSerialNumber(), 0L, 0L, 1L, 4L, channels, this.analogInputGains, 0L);
            int i = 0;
            while (i < channels.length) {
                this.analogInputValues[(int)channels[i]] = voltages[i];
                ++i;
            }
        }
    }

    public void updateAO(int channel) throws LabJackException {
        if (channel < 0 || channel >= 2) {
            throw new LabJackException(21);
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiEAnalogOut(this.getSerialNumber(), this.analogOutputValues[0], this.analogOutputValues[1]);
        }
    }

    public void updateCounter() throws LabJackException {
        this.updateCounter(false);
    }

    public void updateCounter(boolean resetCounter) throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.counter = this.apiECount(this.getSerialNumber(), resetCounter);
        }
    }

    public void updateD(int channel) throws LabJackException {
        if (channel < 0 || channel >= 16) {
            throw new LabJackException(21);
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            if (this.isDForOutput(channel)) {
                this.apiEDigitalOut(this.getSerialNumber(), channel, true, this.getDigitalDValue(channel));
            } else {
                boolean value = this.apiEDigitalIn(this.getSerialNumber(), channel, true);
                this.setDigitalDValue(channel, value);
            }
        }
    }

    public void updateDifferentialAI(int channel) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            float value;
            this.analogInputValues[8 + channel] = value = this.apiEAnalogIn(this.getSerialNumber(), 8 + channel, this.getDifferentialAIGain(channel));
        }
    }

    public void updateEnvironmentals() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiSHT1X(this.getSerialNumber());
        }
    }

    public void updateHighAIs() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            long[] channels = new long[]{4L, 5L, 6L, 7L};
            long[] gains = new long[4];
            float[] voltages = this.apiAISample(this.getSerialNumber(), 0L, 0L, 1L, 4L, channels, gains, 0L);
            int i = 0;
            while (i < channels.length) {
                this.analogInputValues[(int)channels[i]] = voltages[i];
                ++i;
            }
        }
    }

    public void updateIO(int channel) throws LabJackException {
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            if (this.isIOForOutput(channel)) {
                this.apiEDigitalOut(this.getSerialNumber(), channel, false, this.getDigitalIOValue(channel));
            } else {
                boolean value = this.apiEDigitalIn(this.getSerialNumber(), channel, false);
                this.setDigitalIOValue(channel, value);
            }
        }
    }

    public void updateLowAIs() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            long[] lArray = new long[4];
            lArray[1] = 1L;
            lArray[2] = 2L;
            lArray[3] = 3L;
            long[] channels = lArray;
            long[] gains = new long[4];
            float[] voltages = this.apiAISample(this.getSerialNumber(), 0L, 0L, 1L, 4L, channels, gains, 0L);
            int i = 0;
            while (i < channels.length) {
                this.analogInputValues[(int)channels[i]] = voltages[i];
                ++i;
            }
        }
    }

    public float updateScanFromBurst(long[] channels, float scanRate, int scans, int timeout, boolean updateIO, boolean triggerIO, boolean triggerState, long transferMode, boolean ledOn) throws LabJackException {
        float actualScanRate;
        Class clazz = thisClass;
        synchronized (clazz) {
            LabJackScan newScan = new LabJackScan();
            actualScanRate = this.apiAIBurst(this.getSerialNumber(), this.digitalIOValues & this.digitalIODirections, updateIO ? 1 : 0, ledOn ? 1 : 0, channels.length, channels, this.getGains(channels), scanRate, 0L, triggerIO ? 1 : 0, triggerState ? 1 : 0, scans, timeout, transferMode, newScan);
            this.scan = newScan;
        }
        return actualScanRate;
    }

    private long[] getGains(long[] channels) {
        long[] gains = new long[channels.length];
        int i = 0;
        while (i < channels.length) {
            if (channels[i] >= 8L) {
                gains[i] = this.analogInputGains[(int)channels[i] - 8];
            }
            ++i;
        }
        return gains;
    }

    public float updateScanFromBurst(long[] channels, float scanRate, int scans) throws LabJackException {
        return this.updateScanFromBurst(channels, scanRate, scans, 10, false, false, false, 0L, true);
    }

    public void updateLocalId() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiLocalID(this.getSerialNumber(), this.getLocalId());
        }
    }

    public void reset() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiReset(this.getSerialNumber());
        }
    }

    public void reenumerate() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiReEnum(this.getSerialNumber());
        }
    }

    public void updateFirmwareVersion() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.setFirmwareVersion(this.apiGetFirmwareVersion(this.getSerialNumber()));
        }
    }

    public void setPulseWidth(float pulseWidth) {
        float bestGuess = Float.MAX_VALUE;
        int b = 1;
        while (b < 256) {
            int c = 1;
            while (c < 256) {
                float thisGuess = this.calcPulseWidth(b, c);
                if (Math.abs(pulseWidth - thisGuess) < bestGuess) {
                    this.pulseB1 = b;
                    this.pulseC1 = c;
                    bestGuess = Math.abs(pulseWidth - thisGuess);
                }
                ++c;
            }
            ++b;
        }
    }

    public void setPulseSpace(float pulseSpace) {
        float bestGuess = Float.MAX_VALUE;
        int b = 1;
        while (b < 256) {
            int c = 1;
            while (c < 256) {
                float thisGuess = this.calcPulseSpace(b, c);
                if (Math.abs(pulseSpace - thisGuess) < bestGuess) {
                    this.pulseB2 = b;
                    this.pulseC2 = c;
                    bestGuess = Math.abs(pulseSpace - thisGuess);
                }
                ++c;
            }
            ++b;
        }
    }

    public float getPulseWidth() {
        return this.calcPulseWidth(this.pulseB1, this.pulseC1);
    }

    public float getPulseSpace() {
        return this.calcPulseSpace(this.pulseB2, this.pulseC2);
    }

    private float calcPulseWidth(int b, int c) {
        return 17.0f + 0.83f * (float)c + 20.17f * (float)b * (float)c;
    }

    private float calcPulseSpace(int b, int c) {
        return 12.0f + 0.83f * (float)c + 20.17f * (float)b * (float)c;
    }

    private int getBitSelect(boolean[] dChannels) {
        int bitSelect = 0;
        int i = 0;
        while (i < Math.min(8, dChannels.length)) {
            bitSelect <<= 1;
            if (dChannels[i]) {
                ++bitSelect;
            }
            ++i;
        }
        return bitSelect;
    }

    private void updatePulse(int numPulses, int bitSelect, boolean lowFirst) throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiPulseOut(this.getSerialNumber(), lowFirst ? 0 : 1, bitSelect, numPulses, this.pulseB1, this.pulseC1, this.pulseB2, this.pulseC2);
        }
    }

    public void updatePulse(int dChannel, int numPulses) throws LabJackException {
        this.updatePulse(numPulses, 1 << dChannel, true);
    }

    public void updatePulse(boolean[] dChannels, int numPulses) throws LabJackException {
        this.updatePulse(numPulses, this.getBitSelect(dChannels), true);
    }

    public void updatePulse(boolean[] dChannels, int numPulses, boolean lowFirst) throws LabJackException {
        this.updatePulse(numPulses, this.getBitSelect(dChannels), lowFirst);
    }

    private void updatePulseAsynch(int numPulses, int bitSelect, boolean lowFirst) throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiPulseOutStart(this.getSerialNumber(), lowFirst ? 0 : 1, bitSelect, numPulses, this.pulseB1, this.pulseC1, this.pulseB2, this.pulseC2);
        }
    }

    public void updatePulseAsynch(int dChannel, int numPulses) throws LabJackException {
        this.updatePulseAsynch(numPulses, 1 << dChannel, true);
    }

    public void updatePulseAsynch(boolean[] dChannels, int numPulses) throws LabJackException {
        this.updatePulseAsynch(numPulses, this.getBitSelect(dChannels), true);
    }

    public void updatePulseAsynch(boolean[] dChannels, int numPulses, boolean lowFirst) throws LabJackException {
        this.updatePulseAsynch(numPulses, this.getBitSelect(dChannels), lowFirst);
    }

    public void updatePulseAsynchFinish(int timeoutMS) throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiPulseOutFinish(this.getSerialNumber(), timeoutMS);
        }
    }

    public float updateStreamStart(long[] channels, float scanRate, boolean readCount) throws LabJackException {
        float actualScanRate;
        Class clazz = thisClass;
        synchronized (clazz) {
            actualScanRate = this.apiAIStreamStart(this.getSerialNumber(), 0L, 0L, 1L, channels.length, channels, this.getGains(channels), scanRate, 0L, readCount ? 1 : 0);
        }
        return actualScanRate;
    }

    public float updateStreamStart(long[] channels, float scanRate) throws LabJackException {
        return this.updateStreamStart(channels, scanRate, false);
    }

    public void updateStreamClear() throws LabJackException {
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiAIStreamClear(this.getLocalId());
        }
    }

    public void updateScanFromStream(int scans) throws LabJackException {
        this.updateScanFromStream(scans, 10);
    }

    public void updateScanFromStream(int scans, int timeout) throws LabJackException {
        LabJackScan newScan = new LabJackScan();
        Class clazz = thisClass;
        synchronized (clazz) {
            this.apiAIStreamRead(this.getLocalId(), scans, timeout, newScan);
        }
        this.scan = newScan;
    }
}

