/*
 * Decompiled with CFR 0.152.
 */
package com.teravation.labjack.monitor;

import com.teravation.labjack.LabJack;
import com.teravation.labjack.LabJackException;
import com.teravation.labjack.LabJackFactory;
import com.teravation.labjack.monitor.LabJackMonitorFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LabJackSelectionFrame
extends JFrame {
    private JPanel ivjJFrameContentPane = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private LabJackMonitorFrame[] demoFrames;
    private JList ivjJListLabJacks = null;
    private JLabel ivjJLabelInstructions = null;
    private JScrollPane ivjJScrollPaneLabJacks = null;

    public LabJackSelectionFrame() {
        this.initialize();
    }

    public LabJackSelectionFrame(String title) {
        super(title);
    }

    private void connEtoC2(MouseEvent arg1) {
        try {
            this.listLabJacks_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getJLabelInstructions(), "North");
                this.getJFrameContentPane().add((Component)this.getJScrollPaneLabJacks(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabelInstructions() {
        if (this.ivjJLabelInstructions == null) {
            try {
                this.ivjJLabelInstructions = new JLabel();
                this.ivjJLabelInstructions.setName("JLabelInstructions");
                this.ivjJLabelInstructions.setText("Double click a LabJack to monitor");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelInstructions;
    }

    private JList getJListLabJacks() {
        if (this.ivjJListLabJacks == null) {
            try {
                this.ivjJListLabJacks = new JList();
                this.ivjJListLabJacks.setName("JListLabJacks");
                this.ivjJListLabJacks.setBounds(0, 0, 202, 20);
                this.ivjJListLabJacks.setSelectionMode(0);
                try {
                    LabJack[] availableLabJacks = new LabJackFactory().getLabJacks();
                    this.demoFrames = new LabJackMonitorFrame[availableLabJacks.length];
                    DefaultListModel<LabJack> model = new DefaultListModel<LabJack>();
                    int i = 0;
                    while (i < availableLabJacks.length) {
                        model.addElement(availableLabJacks[i]);
                        ++i;
                    }
                    this.ivjJListLabJacks.setModel(model);
                }
                catch (LabJackException lje) {
                    lje.printStackTrace(System.err);
                    System.exit(0);
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJListLabJacks;
    }

    private JScrollPane getJScrollPaneLabJacks() {
        if (this.ivjJScrollPaneLabJacks == null) {
            try {
                this.ivjJScrollPaneLabJacks = new JScrollPane();
                this.ivjJScrollPaneLabJacks.setName("JScrollPaneLabJacks");
                this.getJScrollPaneLabJacks().setViewportView(this.getJListLabJacks());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPaneLabJacks;
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getJListLabJacks().addMouseListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("LabJackSelectionFrame");
            this.setDefaultCloseOperation(2);
            ((Component)this).setSize(424, 162);
            this.setTitle("LabJack Monitor");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void listLabJacks_MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            int i = this.getJListLabJacks().getSelectedIndex();
            if (this.demoFrames[i] != null) {
                this.demoFrames[i].show();
            } else {
                LabJackMonitorFrame aLabJackMonitorFrame = new LabJackMonitorFrame((LabJack)this.getJListLabJacks().getSelectedValue());
                aLabJackMonitorFrame.show();
                Insets insets = aLabJackMonitorFrame.getInsets();
                ((Component)aLabJackMonitorFrame).setSize(aLabJackMonitorFrame.getWidth() + insets.left + insets.right, aLabJackMonitorFrame.getHeight() + insets.top + insets.bottom);
                Point windowLocation = this.getLocationOnScreen();
                int offset = this.getHeight() - this.getContentPane().getHeight();
                windowLocation.translate((i + 1) * offset, (i + 1) * offset);
                ((Component)aLabJackMonitorFrame).setLocation(windowLocation);
                ((Component)aLabJackMonitorFrame).setVisible(true);
                this.demoFrames[i] = aLabJackMonitorFrame;
            }
        }
    }

    public static void main(String[] args) {
        try {
            LabJackSelectionFrame aLabJackSelectionFrame = new LabJackSelectionFrame();
            aLabJackSelectionFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            aLabJackSelectionFrame.show();
            Insets insets = aLabJackSelectionFrame.getInsets();
            ((Component)aLabJackSelectionFrame).setSize(aLabJackSelectionFrame.getWidth() + insets.left + insets.right, aLabJackSelectionFrame.getHeight() + insets.top + insets.bottom);
            ((Component)aLabJackSelectionFrame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            exception.printStackTrace(System.out);
        }
    }

    class IvjEventHandler
    implements MouseListener {
        IvjEventHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == LabJackSelectionFrame.this.getJListLabJacks()) {
                LabJackSelectionFrame.this.connEtoC2(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

