package com.teravation.labjack;
/**
 * This file is part of LabJackJava.  Copyright 2003-2004, Teravation.  All rights reserved. 
 * 
 * LabJackJava is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * LabJackJava is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with LabJackJava;
 * if not, write to:
 *    Free Software Foundation, Inc.
 *    59 Temple Place, Suite 330
 *    Boston, MA  02111-1307  USA
 * 
 * In addition, as a special exception, Teravation gives permission to link the code of this program with
 * the LabJack C driver (or with modified versions of the LabJack C driver that use the same license),
 * and distribute linked combinations including the two.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the LabJack C driver.  If you modify this file, you may 
 * extend this exception to your version of the file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 */

/**
 * This class holds all of the constants used in the LabJackJava packages.
 *
 * <p />Copyright &copy; 2003-2004 <a href="http://www.teravation.com">Teravation</a>. All rights reserved.
 * 
 * @created (4/14/2002 2:52:36 PM)
 * @version 4.0
 * @author Chris Reigrut 
 */
/**
 * @author creigrut
 */
public class LabJackConstants {
	/**
	 * Number of analog single input channels (8)
	 */
	static final public int ANALOG_SINGLE_INPUT_CHANNELS = 8;
	
	/**
	 * Number of analog differential input channels (4)
	 */
	static final public int ANALOG_DIFFERENTIAL_INPUT_CHANNELS = 4;
	
	/**
	 * Number of analog input channels (12)
	 */
	static final public int ANALOG_INPUT_CHANNELS = ANALOG_SINGLE_INPUT_CHANNELS + ANALOG_DIFFERENTIAL_INPUT_CHANNELS;
	
	/**
	 * Number of analog output channels (2)
	 */
	static final public int ANALOG_OUTPUT_CHANNELS = 2;
	
	/**
	 * Number of digital IO channels (4)
	 */
	static final public int IO_CHANNELS = 4;
	
	/**
	 * Number of digital D channels (16)
	 */
	static final public int D_CHANNELS = 16;
	
	/**
	 * Number of digital channels (20)
	 */
	static final public int DIGITAL_CHANNELS = IO_CHANNELS + D_CHANNELS;
	
	/**
	 * Maximum number of scans that can be returned
	 */
	static final public int MAX_SCANS = 4096;

	/**
	 * Gain factors for differential channels
	 */
	static final public int GAIN_1x = 0;
	static final public int GAIN_2x = 1;
	static final public int GAIN_4x = 2;
	static final public int GAIN_5x = 3;
	static final public int GAIN_8x = 4;
	static final public int GAIN_10x = 5;
	static final public int GAIN_16x = 6;
	static final public int GAIN_20x = 7;

}
