/*
 * Decompiled with CFR 0.152.
 */
package com.teravation.labjack;

import com.teravation.labjack.LabJackException;

public class LabJackScan {
    private int available = 0;
    private int backlog = 0;
    private float[][] analogInputValues = new float[12][];
    private long[] counterValues = null;
    private long[] digitalIOValues = null;

    LabJackScan() {
    }

    void setAvailable(int scans) {
        this.available = scans;
    }

    void setBacklog(int scans) {
        this.backlog = scans;
    }

    void setCounts(int available, int backlog) {
        this.available = available;
        this.backlog = backlog;
    }

    void setAnalogInputValues(int channel, float[] aiData) {
        this.analogInputValues[channel] = aiData;
    }

    void setCounterValues(long[] counterData) {
        this.counterValues = counterData;
    }

    void setDigitalIOValues(long[] ioData) {
        this.digitalIOValues = ioData;
    }

    public float getAI(int channel, int scan) throws LabJackException {
        if (channel < 0 || channel >= 8) {
            throw new LabJackException(21);
        }
        float[] aiData = this.analogInputValues[channel];
        if (aiData == null) {
            throw new LabJackException(16);
        }
        if (scan < 0 || scan > 4096 || scan > aiData.length) {
            throw new LabJackException(32);
        }
        return aiData[scan];
    }

    public float getDifferentialAI(int channel, int scan) throws LabJackException {
        if (channel < 0 || channel >= 8) {
            throw new LabJackException(21);
        }
        float[] aiData = this.analogInputValues[8 + channel];
        if (aiData == null) {
            throw new LabJackException(16);
        }
        if (scan < 0 || scan > 4096 || scan > aiData.length) {
            throw new LabJackException(32);
        }
        return aiData[scan];
    }

    private boolean getDigitalIOValue(int bit, int scan) throws LabJackException {
        if (scan < 0 || scan > 4096 || scan > this.digitalIOValues.length) {
            throw new LabJackException(32);
        }
        return (this.digitalIOValues[scan] & (long)(1 << bit)) > 0L;
    }

    public boolean getIO(int channel, int scan) throws LabJackException {
        boolean value = false;
        if (channel < 0 || channel >= 4) {
            throw new LabJackException(21);
        }
        return this.getDigitalIOValue(channel, scan);
    }

    public long getCounter(int scan) throws LabJackException {
        return this.counterValues[scan];
    }

    public int getAvailable() {
        return this.available;
    }

    public int getBacklog() {
        return this.backlog;
    }
}

