package com.teravation.labjack.monitor;

import javax.swing.*;
import com.teravation.labjack.*;

/**
 * This file is part of LabJackJava.  Copyright 2003-2004, Teravation.  All rights reserved. 
 * 
 * LabJackJava is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * LabJackJava is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with LabJackJava;
 * if not, write to:
 *    Free Software Foundation, Inc.
 *    59 Temple Place, Suite 330
 *    Boston, MA  02111-1307  USA
 * 
 * In addition, as a special exception, Teravation gives permission to link the code of this program with
 * the LabJack C driver (or with modified versions of the LabJack C driver that use the same license),
 * and distribute linked combinations including the two.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the LabJack C driver.  If you modify this file, you may 
 * extend this exception to your version of the file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 */

/**
 * The monitor frame allows the user to monitor and control a given LabJack object.
 *
 * <p />Copyright &copy; 2003-2004 <a href="http://www.teravation.com">Teravation</a>. All rights reserved.
 * 
 * @created (2/7/2003 10:13:42 PM)
 * @version 4.0
 * @author Chris Reigrut 
 */
public class LabJackMonitorFrame extends JFrame {
	/**
	 * The update thread is responsible for caling the LabJack's <code>updateXXXXX</code> methods
	 * to ensure that the state of the device matches the state of the object. 
	 */
	class UpdateThread extends Thread {
		private boolean stopping = false;

		public void run() {
			while (!stopping) {
				try {
					labjack.updateAllAOsAndDigitals(resetCounter);
					labjack.updateAllAIs();
					labjack.updateAllDifferentialAIs();
					resetCounter = false;

					for (int i = 0; i < LabJackConstants.IO_CHANNELS; i++) {
						if (!cbIOs[i].isSelected()) {
							rbIOs[i].setSelected(labjack.getIO(i));
						}
					}

					for (int i = 0; i < LabJackConstants.D_CHANNELS; i++) {
						if (!cbDs[i].isSelected()) {
							rbDs[i].setSelected(labjack.getD(i));
						}
					}

					for (int i = 0; i < LabJackConstants.ANALOG_SINGLE_INPUT_CHANNELS; i++) {
						tfAIs[i].setText("" + labjack.getAI(i));
					}

					for (int i = 0; i < LabJackConstants.ANALOG_DIFFERENTIAL_INPUT_CHANNELS; i++) {
						tfDAIs[i].setText("" + labjack.getDifferentialAI(i));
					}

					getJTextFieldCounter().setText("" + labjack.getCounter());
				} catch (LabJackException lje) {
					lje.printStackTrace(System.err);
				}
				try {
					Thread.sleep(100);
				} catch (InterruptedException ioe) {
				}
			}
		}

		void stopRunning() {
			stopping = true;
		}
	}
	
	private static final String[] GAIN_STRINGS = { "1x", "2x", "4x", "5x", "8x", "10x", "16x", "20x" };
	private JCheckBox[] cbIOs = new JCheckBox[LabJackConstants.IO_CHANNELS];
	private JRadioButton[] rbIOs = new JRadioButton[LabJackConstants.IO_CHANNELS];
	private JCheckBox[] cbDs = new JCheckBox[LabJackConstants.D_CHANNELS];
	private JRadioButton[] rbDs = new JRadioButton[LabJackConstants.D_CHANNELS];
	private JTextField[] tfAIs = new JTextField[LabJackConstants.ANALOG_SINGLE_INPUT_CHANNELS];
	private JTextField[] tfDAIs = new JTextField[LabJackConstants.ANALOG_DIFFERENTIAL_INPUT_CHANNELS];
	private JTextField[] tfAOs = new JTextField[LabJackConstants.ANALOG_OUTPUT_CHANNELS];
	private JSlider[] sAOs = new JSlider[LabJackConstants.ANALOG_OUTPUT_CHANNELS];
	private com.teravation.labjack.LabJack labjack = null;
	private UpdateThread updateThread = new UpdateThread();
	private boolean resetCounter = false;
	private JPanel ivjJFrameContentPane = null;
	private JCheckBox ivjcbD10 = null;
	private JCheckBox ivjcbD11 = null;
	private JCheckBox ivjcbD12 = null;
	private JCheckBox ivjcbD13 = null;
	private JCheckBox ivjcbD14 = null;
	private JCheckBox ivjcbD15 = null;
	private JRadioButton ivjrbD10 = null;
	private JRadioButton ivjrbD11 = null;
	private JRadioButton ivjrbD12 = null;
	private JRadioButton ivjrbD13 = null;
	private JRadioButton ivjrbD14 = null;
	private JRadioButton ivjrbD15 = null;
	private JPanel ivjpD = null;
	private JPanel ivjpIO = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private JPanel ivjJPanelDIO = null;
	private JLabel ivjJLabelCounter = null;
	private JButton ivjJButtonCounterReset = null;
	private JPanel ivjJPanelStatus = null;
	private JRadioButton ivjrbIO00 = null;
	private JRadioButton ivjrbIO01 = null;
	private JRadioButton ivjrbIO02 = null;
	private JRadioButton ivjrbIO03 = null;
	private JCheckBox ivjcbIO00 = null;
	private JCheckBox ivjcbIO01 = null;
	private JCheckBox ivjcbIO02 = null;
	private JCheckBox ivjcbIO03 = null;
	private JRadioButton ivjrbD00 = null;
	private JRadioButton ivjrbD01 = null;
	private JRadioButton ivjrbD02 = null;
	private JRadioButton ivjrbD03 = null;
	private JRadioButton ivjrbD04 = null;
	private JRadioButton ivjrbD05 = null;
	private JRadioButton ivjrbD06 = null;
	private JRadioButton ivjrbD07 = null;
	private JRadioButton ivjrbD08 = null;
	private JRadioButton ivjrbD09 = null;
	private JCheckBox ivjcbD00 = null;
	private JCheckBox ivjcbD01 = null;
	private JCheckBox ivjcbD02 = null;
	private JCheckBox ivjcbD03 = null;
	private JCheckBox ivjcbD04 = null;
	private JCheckBox ivjcbD05 = null;
	private JCheckBox ivjcbD06 = null;
	private JCheckBox ivjcbD07 = null;
	private JCheckBox ivjcbD08 = null;
	private JCheckBox ivjcbD09 = null;
	private JLabel ivjJLabelAI0 = null;
	private JLabel ivjJLabelAI1 = null;
	private JLabel ivjJLabelAI2 = null;
	private JLabel ivjJLabelAI3 = null;
	private JLabel ivjJLabelAI4 = null;
	private JLabel ivjJLabelAI5 = null;
	private JLabel ivjJLabelAI6 = null;
	private JLabel ivjJLabelAI7 = null;
	private JLabel ivjJLabelAO0 = null;
	private JLabel ivjJLabelAO1 = null;
	private JSlider ivjJSliderAO0 = null;
	private JSlider ivjJSliderAO1 = null;
	private JTextField ivjJTextFieldAI0 = null;
	private JTextField ivjJTextFieldAI1 = null;
	private JTextField ivjJTextFieldAI2 = null;
	private JTextField ivjJTextFieldAI3 = null;
	private JTextField ivjJTextFieldAI4 = null;
	private JTextField ivjJTextFieldAI5 = null;
	private JTextField ivjJTextFieldAI6 = null;
	private JTextField ivjJTextFieldAI7 = null;
	private JTextField ivjJTextFieldAO0 = null;
	private JTextField ivjJTextFieldAO1 = null;
	private JPanel ivjJPanelAI = null;
	private JPanel ivjJPanelAnalog = null;
	private JPanel ivjJPanelAO = null;
	private JScrollPane ivjJScrollPaneDIO = null;
	private JComboBox ivjJComboBoxDAI0 = null;
	private JComboBox ivjJComboBoxDAI1 = null;
	private JComboBox ivjJComboBoxDAI2 = null;
	private JComboBox ivjJComboBoxDAI3 = null;
	private JLabel ivjJLabelDAI0 = null;
	private JLabel ivjJLabelDAI1 = null;
	private JLabel ivjJLabelDAI2 = null;
	private JLabel ivjJLabelDAI3 = null;
	private JPanel ivjJPanelDAI = null;
	private JTextField ivjJTextFieldDAI0 = null;
	private JTextField ivjJTextFieldDAI1 = null;
	private JTextField ivjJTextFieldDAI2 = null;
	private JTextField ivjJTextFieldDAI3 = null;
	private JPanel ivjJPanelAnalogInput = null;
	private JLabel ivjJLabelDirection = null;
	private JTextField ivjJTextFieldCounter = null;

	class IvjEventHandler implements java.awt.event.ActionListener, java.awt.event.FocusListener, java.awt.event.WindowListener, javax.swing.event.ChangeListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (e.getSource() == LabJackMonitorFrame.this.getcbIO00())
				connEtoC1(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbIO01())
				connEtoC2(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbIO02())
				connEtoC3(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbIO03())
				connEtoC4(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbIO00())
				connEtoC5(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbIO01())
				connEtoC6(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbIO02())
				connEtoC7(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbIO03())
				connEtoC8(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJButtonCounterReset())
				connEtoC9(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD00())
				connEtoC10(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD01())
				connEtoC11(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD02())
				connEtoC12(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD03())
				connEtoC13(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD04())
				connEtoC14(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD05())
				connEtoC15(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD06())
				connEtoC16(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD07())
				connEtoC17(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD08())
				connEtoC18(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD09())
				connEtoC19(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD10())
				connEtoC20(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD11())
				connEtoC21(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD12())
				connEtoC22(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD13())
				connEtoC23(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD14())
				connEtoC24(e);
			if (e.getSource() == LabJackMonitorFrame.this.getcbD15())
				connEtoC25(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD15())
				connEtoC26(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD14())
				connEtoC27(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD13())
				connEtoC28(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD12())
				connEtoC29(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD11())
				connEtoC30(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD10())
				connEtoC31(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD09())
				connEtoC32(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD08())
				connEtoC33(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD07())
				connEtoC34(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD06())
				connEtoC35(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD05())
				connEtoC36(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD04())
				connEtoC37(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD03())
				connEtoC38(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD02())
				connEtoC39(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD01())
				connEtoC40(e);
			if (e.getSource() == LabJackMonitorFrame.this.getrbD00())
				connEtoC41(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJComboBoxDAI0())
				connEtoC46(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJComboBoxDAI1())
				connEtoC47(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJComboBoxDAI2())
				connEtoC48(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJComboBoxDAI3())
				connEtoC49(e);
		};
		public void focusGained(java.awt.event.FocusEvent e) {
		};
		public void focusLost(java.awt.event.FocusEvent e) {
			if (e.getSource() == LabJackMonitorFrame.this.getJTextFieldAO0())
				connEtoC42(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJTextFieldAO1())
				connEtoC45(e);
		};
		public void stateChanged(javax.swing.event.ChangeEvent e) {
			if (e.getSource() == LabJackMonitorFrame.this.getJSliderAO0())
				connEtoC43(e);
			if (e.getSource() == LabJackMonitorFrame.this.getJSliderAO1())
				connEtoC44(e);
		};
		public void windowActivated(java.awt.event.WindowEvent e) {
		};
		public void windowClosed(java.awt.event.WindowEvent e) {
		};
		public void windowClosing(java.awt.event.WindowEvent e) {
			if (e.getSource() == LabJackMonitorFrame.this)
				connEtoC50(e);
		};
		public void windowDeactivated(java.awt.event.WindowEvent e) {
		};
		public void windowDeiconified(java.awt.event.WindowEvent e) {
		};
		public void windowIconified(java.awt.event.WindowEvent e) {
		};
		public void windowOpened(java.awt.event.WindowEvent e) {
		};
	};
	/**
	 * LabJackMonitorFrame constructor comment.
	 */
	public LabJackMonitorFrame() {
		super();
		initialize();
	}
	/**
	 * Insert the method's description here.
	 * @created (2/8/2003 12:30:47 AM)
	 * @param labjack com.teravation.labjack.LabJack
	 */
	public LabJackMonitorFrame(LabJack labjack) {
		super();
		this.setLabJack(labjack);
		initialize();
		updateThread.start();
	}
	/**
	 * LabJackMonitorFrame constructor comment.
	 * @param title java.lang.String
	 */
	public LabJackMonitorFrame(String title) {
		super(title);
	}
	/**
	 * Comment
	 */
	public void cbD_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
		JCheckBox cbSelected = (JCheckBox) actionEvent.getSource();
		String channelString = cbSelected.getName().substring(cbSelected.getName().length() - 2);
		int channel = Integer.parseInt(channelString);
		JRadioButton rbSelected = rbDs[channel];
		if (cbSelected.isSelected()) {
			rbSelected.setEnabled(true);
			try {
				this.getLabJack().setDForOutput(channel);
			} catch (LabJackException lje) {
				lje.printStackTrace(System.err);
			}
		} else {
			rbSelected.setEnabled(false);
			try {
				this.getLabJack().setDForInput(channel);
			} catch (LabJackException lje) {
				lje.printStackTrace(System.err);
			}
		}
	}
	/**
	 * Comment
	 */
	public void cbIO_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
		JCheckBox cbSelected = (JCheckBox) actionEvent.getSource();
		String channelString = cbSelected.getName().substring(cbSelected.getName().length() - 2);
		int channel = Integer.parseInt(channelString);
		JRadioButton rbSelected = rbIOs[channel];
		if (cbSelected.isSelected()) {
			rbSelected.setEnabled(true);
			try {
				this.getLabJack().setIOForOutput(channel);
			} catch (LabJackException lje) {
				lje.printStackTrace(System.err);
			}
		} else {
			rbSelected.setEnabled(false);
			try {
				this.getLabJack().setIOForInput(channel);
			} catch (LabJackException lje) {
				lje.printStackTrace(System.err);
			}
		}
	}
	/**
	 * connEtoC1:  (cbIO0.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC1(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC10:  (cbD0.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC10(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC11:  (cbD1.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC11(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC12:  (cbD2.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC12(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC13:  (cbD3.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC13(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC14:  (cbD4.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC14(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC15:  (cbD5.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC15(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC16:  (cbD6.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC16(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC17:  (cbD7.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC17(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC18:  (cbD8.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC18(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC19:  (cbD9.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC19(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC2:  (cbIO1.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC2(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC20:  (cbD10.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC20(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC21:  (cbD11.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC21(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC22:  (cbD12.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC22(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC23:  (cbD13.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC23(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC24:  (cbD14.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC24(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC25:  (cbD15.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC25(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC26:  (rbD15.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC26(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC27:  (rbD14.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC27(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC28:  (rbD13.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC28(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC29:  (rbD12.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC29(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC3:  (cbIO2.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC3(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC30:  (rbD11.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC30(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC31:  (rbD10.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC31(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC32:  (rbD9.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC32(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC33:  (rbD8.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC33(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC34:  (rbD7.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC34(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC35:  (rbD6.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC35(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC36:  (rbD5.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC36(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC37:  (rbD4.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC37(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC38:  (rbD3.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC38(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC39:  (rbD2.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC39(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC4:  (cbIO3.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.cbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC4(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.cbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC40:  (rbD1.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC40(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC41:  (rbDO.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbD_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC41(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbD_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC42:  (JTextFieldAO0.focus.focusLost(java.awt.event.FocusEvent) --> LabJackMonitorFrame.jTextFieldAO_FocusLost(Ljava.awt.event.FocusEvent;)V)
	 * @param arg1 java.awt.event.FocusEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC42(java.awt.event.FocusEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jTextFieldAO_FocusLost(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC43:  (JSliderAO0.change.stateChanged(javax.swing.event.ChangeEvent) --> LabJackMonitorFrame.jSliderAO_StateChanged(Ljavax.swing.event.ChangeEvent;)V)
	 * @param arg1 javax.swing.event.ChangeEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC43(javax.swing.event.ChangeEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jSliderAO_StateChanged(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC44:  (JSliderAO1.change.stateChanged(javax.swing.event.ChangeEvent) --> LabJackMonitorFrame.jSliderAO_StateChanged(Ljavax.swing.event.ChangeEvent;)V)
	 * @param arg1 javax.swing.event.ChangeEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC44(javax.swing.event.ChangeEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jSliderAO_StateChanged(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC45:  (JTextFieldAO1.focus.focusLost(java.awt.event.FocusEvent) --> LabJackMonitorFrame.jTextFieldAO_FocusLost(Ljava.awt.event.FocusEvent;)V)
	 * @param arg1 java.awt.event.FocusEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC45(java.awt.event.FocusEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jTextFieldAO_FocusLost(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC46:  (JComboBoxDAI0.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.jComboBoxDAI_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC46(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jComboBoxDAI_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC47:  (JComboBoxDAI1.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.jComboBoxDAI_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC47(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jComboBoxDAI_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC48:  (JComboBoxDAI2.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.jComboBoxDAI_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC48(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jComboBoxDAI_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC49:  (JComboBoxDAI3.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.jComboBoxDAI_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC49(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jComboBoxDAI_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC5:  (rbIO0.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC5(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC50:  (LabJackMonitorFrame.window.windowClosing(java.awt.event.WindowEvent) --> LabJackMonitorFrame.labJackDemoFrame_WindowClosing(Ljava.awt.event.WindowEvent;)V)
	 * @param arg1 java.awt.event.WindowEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC50(java.awt.event.WindowEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.labJackDemoFrame_WindowClosing(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC6:  (rbIO1.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC6(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC7:  (rbIO2.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC7(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC8:  (rbIO3.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.rbIO_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC8(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.rbIO_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * connEtoC9:  (JButtonCounterReset.action.actionPerformed(java.awt.event.ActionEvent) --> LabJackMonitorFrame.jButtonCounterReset_ActionPerformed(Ljava.awt.event.ActionEvent;)V)
	 * @param arg1 java.awt.event.ActionEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC9(java.awt.event.ActionEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.jButtonCounterReset_ActionPerformed(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * Return the cbD0 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD00() {
		if (ivjcbD00 == null) {
			try {
				ivjcbD00 = new javax.swing.JCheckBox();
				ivjcbD00.setName("cbD00");
				ivjcbD00.setText("");
				ivjcbD00.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD00.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD00.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD00.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[0] = ivjcbD00;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD00;
	}
	/**
	 * Return the cbD1 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD01() {
		if (ivjcbD01 == null) {
			try {
				ivjcbD01 = new javax.swing.JCheckBox();
				ivjcbD01.setName("cbD01");
				ivjcbD01.setText("");
				ivjcbD01.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD01.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD01.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD01.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[1] = ivjcbD01;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD01;
	}
	/**
	 * Return the cbD2 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD02() {
		if (ivjcbD02 == null) {
			try {
				ivjcbD02 = new javax.swing.JCheckBox();
				ivjcbD02.setName("cbD02");
				ivjcbD02.setText("");
				ivjcbD02.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD02.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD02.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD02.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[2] = ivjcbD02;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD02;
	}
	/**
	 * Return the cbD3 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD03() {
		if (ivjcbD03 == null) {
			try {
				ivjcbD03 = new javax.swing.JCheckBox();
				ivjcbD03.setName("cbD03");
				ivjcbD03.setText("");
				ivjcbD03.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD03.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD03.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD03.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[3] = ivjcbD03;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD03;
	}
	/**
	 * Return the cbD4 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD04() {
		if (ivjcbD04 == null) {
			try {
				ivjcbD04 = new javax.swing.JCheckBox();
				ivjcbD04.setName("cbD04");
				ivjcbD04.setText("");
				ivjcbD04.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD04.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD04.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD04.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[4] = ivjcbD04;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD04;
	}
	/**
	 * Return the cbD5 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD05() {
		if (ivjcbD05 == null) {
			try {
				ivjcbD05 = new javax.swing.JCheckBox();
				ivjcbD05.setName("cbD05");
				ivjcbD05.setText("");
				ivjcbD05.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD05.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD05.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD05.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[5] = ivjcbD05;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD05;
	}
	/**
	 * Return the cbD6 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD06() {
		if (ivjcbD06 == null) {
			try {
				ivjcbD06 = new javax.swing.JCheckBox();
				ivjcbD06.setName("cbD06");
				ivjcbD06.setText("");
				ivjcbD06.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD06.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD06.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD06.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[6] = ivjcbD06;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD06;
	}
	/**
	 * Return the cbD7 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD07() {
		if (ivjcbD07 == null) {
			try {
				ivjcbD07 = new javax.swing.JCheckBox();
				ivjcbD07.setName("cbD07");
				ivjcbD07.setText("");
				ivjcbD07.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD07.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD07.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD07.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[7] = ivjcbD07;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD07;
	}
	/**
	 * Return the cbD8 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD08() {
		if (ivjcbD08 == null) {
			try {
				ivjcbD08 = new javax.swing.JCheckBox();
				ivjcbD08.setName("cbD08");
				ivjcbD08.setText("");
				ivjcbD08.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD08.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD08.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD08.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[8] = ivjcbD08;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD08;
	}
	/**
	 * Return the cbD9 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD09() {
		if (ivjcbD09 == null) {
			try {
				ivjcbD09 = new javax.swing.JCheckBox();
				ivjcbD09.setName("cbD09");
				ivjcbD09.setText("");
				ivjcbD09.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD09.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD09.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD09.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[9] = ivjcbD09;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD09;
	}
	/**
	 * Return the cbD10 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD10() {
		if (ivjcbD10 == null) {
			try {
				ivjcbD10 = new javax.swing.JCheckBox();
				ivjcbD10.setName("cbD10");
				ivjcbD10.setText("");
				ivjcbD10.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD10.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD10.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD10.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[10] = ivjcbD10;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD10;
	}
	/**
	 * Return the cbD11 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD11() {
		if (ivjcbD11 == null) {
			try {
				ivjcbD11 = new javax.swing.JCheckBox();
				ivjcbD11.setName("cbD11");
				ivjcbD11.setText("");
				ivjcbD11.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD11.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD11.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD11.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[11] = ivjcbD11;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD11;
	}
	/**
	 * Return the cbD12 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD12() {
		if (ivjcbD12 == null) {
			try {
				ivjcbD12 = new javax.swing.JCheckBox();
				ivjcbD12.setName("cbD12");
				ivjcbD12.setText("");
				ivjcbD12.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD12.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD12.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD12.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[12] = ivjcbD12;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD12;
	}
	/**
	 * Return the cbD13 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD13() {
		if (ivjcbD13 == null) {
			try {
				ivjcbD13 = new javax.swing.JCheckBox();
				ivjcbD13.setName("cbD13");
				ivjcbD13.setText("");
				ivjcbD13.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD13.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD13.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD13.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[13] = ivjcbD13;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD13;
	}
	/**
	 * Return the cbD14 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD14() {
		if (ivjcbD14 == null) {
			try {
				ivjcbD14 = new javax.swing.JCheckBox();
				ivjcbD14.setName("cbD14");
				ivjcbD14.setText("");
				ivjcbD14.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD14.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD14.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD14.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[14] = ivjcbD14;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD14;
	}
	/**
	 * Return the cbD15 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbD15() {
		if (ivjcbD15 == null) {
			try {
				ivjcbD15 = new javax.swing.JCheckBox();
				ivjcbD15.setName("cbD15");
				ivjcbD15.setText("");
				ivjcbD15.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbD15.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbD15.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbD15.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbDs[15] = ivjcbD15;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbD15;
	}
	/**
	 * Return the cbIO0 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbIO00() {
		if (ivjcbIO00 == null) {
			try {
				ivjcbIO00 = new javax.swing.JCheckBox();
				ivjcbIO00.setName("cbIO00");
				ivjcbIO00.setText("");
				ivjcbIO00.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbIO00.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbIO00.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbIO00.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbIOs[0] = ivjcbIO00;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbIO00;
	}
	/**
	 * Return the cbIO1 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbIO01() {
		if (ivjcbIO01 == null) {
			try {
				ivjcbIO01 = new javax.swing.JCheckBox();
				ivjcbIO01.setName("cbIO01");
				ivjcbIO01.setText("");
				ivjcbIO01.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbIO01.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbIO01.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbIO01.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbIOs[1] = ivjcbIO01;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbIO01;
	}
	/**
	 * Return the cbIO2 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbIO02() {
		if (ivjcbIO02 == null) {
			try {
				ivjcbIO02 = new javax.swing.JCheckBox();
				ivjcbIO02.setName("cbIO02");
				ivjcbIO02.setText("");
				ivjcbIO02.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbIO02.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbIO02.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbIO02.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbIOs[2] = ivjcbIO02;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbIO02;
	}
	/**
	 * Return the cbIO3 property value.
	 * @return javax.swing.JCheckBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JCheckBox getcbIO03() {
		if (ivjcbIO03 == null) {
			try {
				ivjcbIO03 = new javax.swing.JCheckBox();
				ivjcbIO03.setName("cbIO03");
				ivjcbIO03.setText("");
				ivjcbIO03.setMaximumSize(new java.awt.Dimension(20,17));
				ivjcbIO03.setPreferredSize(new java.awt.Dimension(20,17));
				ivjcbIO03.setMargin(new java.awt.Insets(0, 0, 0, 0));
				ivjcbIO03.setMinimumSize(new java.awt.Dimension(20,17));
				// user code begin {1}
				this.cbIOs[3] = ivjcbIO03;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjcbIO03;
	}
	/**
	 * Return the JButtonCounterReset property value.
	 * @return javax.swing.JButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JButton getJButtonCounterReset() {
		if (ivjJButtonCounterReset == null) {
			try {
				ivjJButtonCounterReset = new javax.swing.JButton();
				ivjJButtonCounterReset.setName("JButtonCounterReset");
				ivjJButtonCounterReset.setText("Reset");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJButtonCounterReset;
	}
	/**
	 * Return the JComboBoxDAI0 property value.
	 * @return javax.swing.JComboBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JComboBox getJComboBoxDAI0() {
		if (ivjJComboBoxDAI0 == null) {
			try {
				ivjJComboBoxDAI0 = new javax.swing.JComboBox();
				ivjJComboBoxDAI0.setName("JComboBoxDAI0");
				ivjJComboBoxDAI0.setPreferredSize(new java.awt.Dimension(20, 23));
				ivjJComboBoxDAI0.setMinimumSize(new java.awt.Dimension(20, 23));
				// user code begin {1}
				ivjJComboBoxDAI0.setModel(new DefaultComboBoxModel(GAIN_STRINGS));
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJComboBoxDAI0;
	}
	/**
	 * Return the JComboBoxDAI1 property value.
	 * @return javax.swing.JComboBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JComboBox getJComboBoxDAI1() {
		if (ivjJComboBoxDAI1 == null) {
			try {
				ivjJComboBoxDAI1 = new javax.swing.JComboBox();
				ivjJComboBoxDAI1.setName("JComboBoxDAI1");
				ivjJComboBoxDAI1.setPreferredSize(new java.awt.Dimension(20, 23));
				ivjJComboBoxDAI1.setMinimumSize(new java.awt.Dimension(20, 23));
				// user code begin {1}
				ivjJComboBoxDAI1.setModel(new DefaultComboBoxModel(GAIN_STRINGS));
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJComboBoxDAI1;
	}
	/**
	 * Return the JComboBoxDAI2 property value.
	 * @return javax.swing.JComboBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JComboBox getJComboBoxDAI2() {
		if (ivjJComboBoxDAI2 == null) {
			try {
				ivjJComboBoxDAI2 = new javax.swing.JComboBox();
				ivjJComboBoxDAI2.setName("JComboBoxDAI2");
				ivjJComboBoxDAI2.setPreferredSize(new java.awt.Dimension(20, 23));
				ivjJComboBoxDAI2.setMinimumSize(new java.awt.Dimension(20, 23));
				// user code begin {1}
				ivjJComboBoxDAI2.setModel(new DefaultComboBoxModel(GAIN_STRINGS));
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJComboBoxDAI2;
	}
	/**
	 * Return the JComboBoxDAI3 property value.
	 * @return javax.swing.JComboBox
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JComboBox getJComboBoxDAI3() {
		if (ivjJComboBoxDAI3 == null) {
			try {
				ivjJComboBoxDAI3 = new javax.swing.JComboBox();
				ivjJComboBoxDAI3.setName("JComboBoxDAI3");
				ivjJComboBoxDAI3.setPreferredSize(new java.awt.Dimension(20, 23));
				ivjJComboBoxDAI3.setMinimumSize(new java.awt.Dimension(20, 23));
				// user code begin {1}
				ivjJComboBoxDAI3.setModel(new DefaultComboBoxModel(GAIN_STRINGS));
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJComboBoxDAI3;
	}
	/**
	 * Return the JFrameContentPane property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJFrameContentPane() {
		if (ivjJFrameContentPane == null) {
			try {
				ivjJFrameContentPane = new javax.swing.JPanel();
				ivjJFrameContentPane.setName("JFrameContentPane");
				ivjJFrameContentPane.setLayout(new java.awt.BorderLayout());
				ivjJFrameContentPane.setMinimumSize(new java.awt.Dimension(8, 178));
				getJFrameContentPane().add(getJScrollPaneDIO(), "West");
				getJFrameContentPane().add(getJPanelAnalog(), "East");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJFrameContentPane;
	}
	/**
	 * Return the JLabelAI0 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI0() {
		if (ivjJLabelAI0 == null) {
			try {
				ivjJLabelAI0 = new javax.swing.JLabel();
				ivjJLabelAI0.setName("JLabelAI0");
				ivjJLabelAI0.setText("AI0");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI0;
	}
	/**
	 * Return the JLabelAI1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI1() {
		if (ivjJLabelAI1 == null) {
			try {
				ivjJLabelAI1 = new javax.swing.JLabel();
				ivjJLabelAI1.setName("JLabelAI1");
				ivjJLabelAI1.setText("AI1");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI1;
	}
	/**
	 * Return the JLabelAI2 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI2() {
		if (ivjJLabelAI2 == null) {
			try {
				ivjJLabelAI2 = new javax.swing.JLabel();
				ivjJLabelAI2.setName("JLabelAI2");
				ivjJLabelAI2.setText("AI2");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI2;
	}
	/**
	 * Return the JLabelAI3 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI3() {
		if (ivjJLabelAI3 == null) {
			try {
				ivjJLabelAI3 = new javax.swing.JLabel();
				ivjJLabelAI3.setName("JLabelAI3");
				ivjJLabelAI3.setText("AI3");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI3;
	}
	/**
	 * Return the JLabelAI4 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI4() {
		if (ivjJLabelAI4 == null) {
			try {
				ivjJLabelAI4 = new javax.swing.JLabel();
				ivjJLabelAI4.setName("JLabelAI4");
				ivjJLabelAI4.setText("AI4");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI4;
	}
	/**
	 * Return the JLabelAI5 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI5() {
		if (ivjJLabelAI5 == null) {
			try {
				ivjJLabelAI5 = new javax.swing.JLabel();
				ivjJLabelAI5.setName("JLabelAI5");
				ivjJLabelAI5.setText("AI5");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI5;
	}
	/**
	 * Return the JLabelAI6 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI6() {
		if (ivjJLabelAI6 == null) {
			try {
				ivjJLabelAI6 = new javax.swing.JLabel();
				ivjJLabelAI6.setName("JLabelAI6");
				ivjJLabelAI6.setText("AI6");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI6;
	}
	/**
	 * Return the JLabelAI7 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAI7() {
		if (ivjJLabelAI7 == null) {
			try {
				ivjJLabelAI7 = new javax.swing.JLabel();
				ivjJLabelAI7.setName("JLabelAI7");
				ivjJLabelAI7.setText("AI7");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAI7;
	}
	/**
	 * Return the JLabelAO0 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAO0() {
		if (ivjJLabelAO0 == null) {
			try {
				ivjJLabelAO0 = new javax.swing.JLabel();
				ivjJLabelAO0.setName("JLabelAO0");
				ivjJLabelAO0.setText("AO0");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAO0;
	}
	/**
	 * Return the JLabelAO1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelAO1() {
		if (ivjJLabelAO1 == null) {
			try {
				ivjJLabelAO1 = new javax.swing.JLabel();
				ivjJLabelAO1.setName("JLabelAO1");
				ivjJLabelAO1.setText("AO1");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelAO1;
	}
	/**
	 * Return the JLabel1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelCounter() {
		if (ivjJLabelCounter == null) {
			try {
				ivjJLabelCounter = new javax.swing.JLabel();
				ivjJLabelCounter.setName("JLabelCounter");
				ivjJLabelCounter.setAlignmentX(java.awt.Component.RIGHT_ALIGNMENT);
				ivjJLabelCounter.setText("Counter");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelCounter;
	}
	/**
	 * Return the JLabelDAI0 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelDAI0() {
		if (ivjJLabelDAI0 == null) {
			try {
				ivjJLabelDAI0 = new javax.swing.JLabel();
				ivjJLabelDAI0.setName("JLabelDAI0");
				ivjJLabelDAI0.setText("DAI0");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelDAI0;
	}
	/**
	 * Return the JLabelDAI1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelDAI1() {
		if (ivjJLabelDAI1 == null) {
			try {
				ivjJLabelDAI1 = new javax.swing.JLabel();
				ivjJLabelDAI1.setName("JLabelDAI1");
				ivjJLabelDAI1.setText("DAI1");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelDAI1;
	}
	/**
	 * Return the JLabelDAI2 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelDAI2() {
		if (ivjJLabelDAI2 == null) {
			try {
				ivjJLabelDAI2 = new javax.swing.JLabel();
				ivjJLabelDAI2.setName("JLabelDAI2");
				ivjJLabelDAI2.setText("DAI2");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelDAI2;
	}
	/**
	 * Return the JLabelDAI3 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelDAI3() {
		if (ivjJLabelDAI3 == null) {
			try {
				ivjJLabelDAI3 = new javax.swing.JLabel();
				ivjJLabelDAI3.setName("JLabelDAI3");
				ivjJLabelDAI3.setText("DAI3");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelDAI3;
	}
	/**
	 * Return the JLabel1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelDirection() {
		if (ivjJLabelDirection == null) {
			try {
				ivjJLabelDirection = new javax.swing.JLabel();
				ivjJLabelDirection.setName("JLabelDirection");
				ivjJLabelDirection.setIconTextGap(4);
				ivjJLabelDirection.setText("Out");
				ivjJLabelDirection.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
				ivjJLabelDirection.setAlignmentX(java.awt.Component.CENTER_ALIGNMENT);
				ivjJLabelDirection.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelDirection;
	}
	/**
	 * Return the JPanel3 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelAI() {
		if (ivjJPanelAI == null) {
			try {
				ivjJPanelAI = new javax.swing.JPanel();
				ivjJPanelAI.setName("JPanelAI");
				ivjJPanelAI.setLayout(new java.awt.GridBagLayout());
				ivjJPanelAI.setAlignmentY(java.awt.Component.CENTER_ALIGNMENT);

				java.awt.GridBagConstraints constraintsJLabelAI0 = new java.awt.GridBagConstraints();
				constraintsJLabelAI0.gridx = -1;
				constraintsJLabelAI0.gridy = -1;
				constraintsJLabelAI0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI0(), constraintsJLabelAI0);

				java.awt.GridBagConstraints constraintsJLabelAI1 = new java.awt.GridBagConstraints();
				constraintsJLabelAI1.gridx = 0;
				constraintsJLabelAI1.gridy = 1;
				constraintsJLabelAI1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI1(), constraintsJLabelAI1);

				java.awt.GridBagConstraints constraintsJLabelAI2 = new java.awt.GridBagConstraints();
				constraintsJLabelAI2.gridx = 0;
				constraintsJLabelAI2.gridy = 2;
				constraintsJLabelAI2.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI2(), constraintsJLabelAI2);

				java.awt.GridBagConstraints constraintsJLabelAI3 = new java.awt.GridBagConstraints();
				constraintsJLabelAI3.gridx = 0;
				constraintsJLabelAI3.gridy = 3;
				constraintsJLabelAI3.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI3(), constraintsJLabelAI3);

				java.awt.GridBagConstraints constraintsJLabelAI4 = new java.awt.GridBagConstraints();
				constraintsJLabelAI4.gridx = 0;
				constraintsJLabelAI4.gridy = 4;
				constraintsJLabelAI4.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI4(), constraintsJLabelAI4);

				java.awt.GridBagConstraints constraintsJLabelAI5 = new java.awt.GridBagConstraints();
				constraintsJLabelAI5.gridx = 0;
				constraintsJLabelAI5.gridy = 5;
				constraintsJLabelAI5.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI5(), constraintsJLabelAI5);

				java.awt.GridBagConstraints constraintsJLabelAI6 = new java.awt.GridBagConstraints();
				constraintsJLabelAI6.gridx = 0;
				constraintsJLabelAI6.gridy = 6;
				constraintsJLabelAI6.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI6(), constraintsJLabelAI6);

				java.awt.GridBagConstraints constraintsJLabelAI7 = new java.awt.GridBagConstraints();
				constraintsJLabelAI7.gridx = 0;
				constraintsJLabelAI7.gridy = 7;
				constraintsJLabelAI7.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJLabelAI7(), constraintsJLabelAI7);

				java.awt.GridBagConstraints constraintsJTextFieldAI0 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI0.gridx = 1;
				constraintsJTextFieldAI0.gridy = 0;
				constraintsJTextFieldAI0.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI0.weightx = 1.0;
				constraintsJTextFieldAI0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI0(), constraintsJTextFieldAI0);

				java.awt.GridBagConstraints constraintsJTextFieldAI1 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI1.gridx = 1;
				constraintsJTextFieldAI1.gridy = 1;
				constraintsJTextFieldAI1.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI1.weightx = 1.0;
				constraintsJTextFieldAI1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI1(), constraintsJTextFieldAI1);

				java.awt.GridBagConstraints constraintsJTextFieldAI2 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI2.gridx = 1;
				constraintsJTextFieldAI2.gridy = 2;
				constraintsJTextFieldAI2.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI2.weightx = 1.0;
				constraintsJTextFieldAI2.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI2(), constraintsJTextFieldAI2);

				java.awt.GridBagConstraints constraintsJTextFieldAI3 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI3.gridx = 1;
				constraintsJTextFieldAI3.gridy = 3;
				constraintsJTextFieldAI3.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI3.weightx = 1.0;
				constraintsJTextFieldAI3.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI3(), constraintsJTextFieldAI3);

				java.awt.GridBagConstraints constraintsJTextFieldAI4 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI4.gridx = 1;
				constraintsJTextFieldAI4.gridy = 4;
				constraintsJTextFieldAI4.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI4.weightx = 1.0;
				constraintsJTextFieldAI4.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI4(), constraintsJTextFieldAI4);

				java.awt.GridBagConstraints constraintsJTextFieldAI5 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI5.gridx = 1;
				constraintsJTextFieldAI5.gridy = 5;
				constraintsJTextFieldAI5.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI5.weightx = 1.0;
				constraintsJTextFieldAI5.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI5(), constraintsJTextFieldAI5);

				java.awt.GridBagConstraints constraintsJTextFieldAI6 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI6.gridx = 1;
				constraintsJTextFieldAI6.gridy = 6;
				constraintsJTextFieldAI6.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI6.weightx = 1.0;
				constraintsJTextFieldAI6.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI6(), constraintsJTextFieldAI6);

				java.awt.GridBagConstraints constraintsJTextFieldAI7 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAI7.gridx = 1;
				constraintsJTextFieldAI7.gridy = 7;
				constraintsJTextFieldAI7.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAI7.weightx = 1.0;
				constraintsJTextFieldAI7.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAI().add(getJTextFieldAI7(), constraintsJTextFieldAI7);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelAI;
	}
	/**
	 * Return the JPanel1 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelAnalog() {
		if (ivjJPanelAnalog == null) {
			try {
				ivjJPanelAnalog = new javax.swing.JPanel();
				ivjJPanelAnalog.setName("JPanelAnalog");
				ivjJPanelAnalog.setLayout(new java.awt.BorderLayout());
				getJPanelAnalog().add(getJPanelAO(), "North");
				getJPanelAnalog().add(getJPanelAnalogInput(), "Center");
				getJPanelAnalog().add(getJPanelStatus(), "South");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelAnalog;
	}
	/**
	 * Return the JPanelAnalogInput property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelAnalogInput() {
		if (ivjJPanelAnalogInput == null) {
			try {
				ivjJPanelAnalogInput = new javax.swing.JPanel();
				ivjJPanelAnalogInput.setName("JPanelAnalogInput");
				ivjJPanelAnalogInput.setLayout(new sun.awt.VerticalBagLayout());
				getJPanelAnalogInput().add(getJPanelAI(), getJPanelAI().getName());
				getJPanelAnalogInput().add(getJPanelDAI(), getJPanelDAI().getName());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelAnalogInput;
	}
	/**
	 * Return the JPanel2 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelAO() {
		if (ivjJPanelAO == null) {
			try {
				ivjJPanelAO = new javax.swing.JPanel();
				ivjJPanelAO.setName("JPanelAO");
				ivjJPanelAO.setLayout(new java.awt.GridBagLayout());

				java.awt.GridBagConstraints constraintsJLabelAO0 = new java.awt.GridBagConstraints();
				constraintsJLabelAO0.gridx = 0;
				constraintsJLabelAO0.gridy = 0;
				constraintsJLabelAO0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAO().add(getJLabelAO0(), constraintsJLabelAO0);

				java.awt.GridBagConstraints constraintsJTextFieldAO0 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAO0.gridx = -1;
				constraintsJTextFieldAO0.gridy = -1;
				constraintsJTextFieldAO0.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAO0.weightx = 1.0;
				constraintsJTextFieldAO0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAO().add(getJTextFieldAO0(), constraintsJTextFieldAO0);

				java.awt.GridBagConstraints constraintsJSliderAO0 = new java.awt.GridBagConstraints();
				constraintsJSliderAO0.gridx = 0;
				constraintsJSliderAO0.gridy = 1;
				constraintsJSliderAO0.gridwidth = 3;
				constraintsJSliderAO0.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJSliderAO0.weightx = 1.0;
				constraintsJSliderAO0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAO().add(getJSliderAO0(), constraintsJSliderAO0);

				java.awt.GridBagConstraints constraintsJLabelAO1 = new java.awt.GridBagConstraints();
				constraintsJLabelAO1.gridx = 0;
				constraintsJLabelAO1.gridy = 2;
				constraintsJLabelAO1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAO().add(getJLabelAO1(), constraintsJLabelAO1);

				java.awt.GridBagConstraints constraintsJTextFieldAO1 = new java.awt.GridBagConstraints();
				constraintsJTextFieldAO1.gridx = 1;
				constraintsJTextFieldAO1.gridy = 2;
				constraintsJTextFieldAO1.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldAO1.weightx = 1.0;
				constraintsJTextFieldAO1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAO().add(getJTextFieldAO1(), constraintsJTextFieldAO1);

				java.awt.GridBagConstraints constraintsJSliderAO1 = new java.awt.GridBagConstraints();
				constraintsJSliderAO1.gridx = 0;
				constraintsJSliderAO1.gridy = 4;
				constraintsJSliderAO1.gridwidth = 3;
				constraintsJSliderAO1.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJSliderAO1.weightx = 1.0;
				constraintsJSliderAO1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelAO().add(getJSliderAO1(), constraintsJSliderAO1);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelAO;
	}
	/**
	 * Return the JPanelDAI property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelDAI() {
		if (ivjJPanelDAI == null) {
			try {
				ivjJPanelDAI = new javax.swing.JPanel();
				ivjJPanelDAI.setName("JPanelDAI");
				ivjJPanelDAI.setLayout(new java.awt.GridBagLayout());

				java.awt.GridBagConstraints constraintsJLabelDAI0 = new java.awt.GridBagConstraints();
				constraintsJLabelDAI0.gridx = 0;
				constraintsJLabelDAI0.gridy = 0;
				constraintsJLabelDAI0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJLabelDAI0(), constraintsJLabelDAI0);

				java.awt.GridBagConstraints constraintsJComboBoxDAI0 = new java.awt.GridBagConstraints();
				constraintsJComboBoxDAI0.gridx = 1;
				constraintsJComboBoxDAI0.gridy = 0;
				constraintsJComboBoxDAI0.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJComboBoxDAI0.weightx = 1.0;
				constraintsJComboBoxDAI0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJComboBoxDAI0(), constraintsJComboBoxDAI0);

				java.awt.GridBagConstraints constraintsJTextFieldDAI0 = new java.awt.GridBagConstraints();
				constraintsJTextFieldDAI0.gridx = 2;
				constraintsJTextFieldDAI0.gridy = 0;
				constraintsJTextFieldDAI0.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldDAI0.weightx = 1.0;
				constraintsJTextFieldDAI0.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJTextFieldDAI0(), constraintsJTextFieldDAI0);

				java.awt.GridBagConstraints constraintsJLabelDAI1 = new java.awt.GridBagConstraints();
				constraintsJLabelDAI1.gridx = 0;
				constraintsJLabelDAI1.gridy = 1;
				constraintsJLabelDAI1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJLabelDAI1(), constraintsJLabelDAI1);

				java.awt.GridBagConstraints constraintsJLabelDAI2 = new java.awt.GridBagConstraints();
				constraintsJLabelDAI2.gridx = 0;
				constraintsJLabelDAI2.gridy = 2;
				constraintsJLabelDAI2.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJLabelDAI2(), constraintsJLabelDAI2);

				java.awt.GridBagConstraints constraintsJLabelDAI3 = new java.awt.GridBagConstraints();
				constraintsJLabelDAI3.gridx = 0;
				constraintsJLabelDAI3.gridy = 3;
				constraintsJLabelDAI3.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJLabelDAI3(), constraintsJLabelDAI3);

				java.awt.GridBagConstraints constraintsJComboBoxDAI1 = new java.awt.GridBagConstraints();
				constraintsJComboBoxDAI1.gridx = 1;
				constraintsJComboBoxDAI1.gridy = 1;
				constraintsJComboBoxDAI1.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJComboBoxDAI1.weightx = 1.0;
				constraintsJComboBoxDAI1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJComboBoxDAI1(), constraintsJComboBoxDAI1);

				java.awt.GridBagConstraints constraintsJComboBoxDAI2 = new java.awt.GridBagConstraints();
				constraintsJComboBoxDAI2.gridx = 1;
				constraintsJComboBoxDAI2.gridy = 2;
				constraintsJComboBoxDAI2.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJComboBoxDAI2.weightx = 1.0;
				constraintsJComboBoxDAI2.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJComboBoxDAI2(), constraintsJComboBoxDAI2);

				java.awt.GridBagConstraints constraintsJComboBoxDAI3 = new java.awt.GridBagConstraints();
				constraintsJComboBoxDAI3.gridx = 1;
				constraintsJComboBoxDAI3.gridy = 3;
				constraintsJComboBoxDAI3.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJComboBoxDAI3.weightx = 1.0;
				constraintsJComboBoxDAI3.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJComboBoxDAI3(), constraintsJComboBoxDAI3);

				java.awt.GridBagConstraints constraintsJTextFieldDAI1 = new java.awt.GridBagConstraints();
				constraintsJTextFieldDAI1.gridx = 2;
				constraintsJTextFieldDAI1.gridy = 1;
				constraintsJTextFieldDAI1.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldDAI1.weightx = 1.0;
				constraintsJTextFieldDAI1.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJTextFieldDAI1(), constraintsJTextFieldDAI1);

				java.awt.GridBagConstraints constraintsJTextFieldDAI2 = new java.awt.GridBagConstraints();
				constraintsJTextFieldDAI2.gridx = 2;
				constraintsJTextFieldDAI2.gridy = 2;
				constraintsJTextFieldDAI2.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldDAI2.weightx = 1.0;
				constraintsJTextFieldDAI2.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJTextFieldDAI2(), constraintsJTextFieldDAI2);

				java.awt.GridBagConstraints constraintsJTextFieldDAI3 = new java.awt.GridBagConstraints();
				constraintsJTextFieldDAI3.gridx = 2;
				constraintsJTextFieldDAI3.gridy = 3;
				constraintsJTextFieldDAI3.fill = java.awt.GridBagConstraints.HORIZONTAL;
				constraintsJTextFieldDAI3.weightx = 1.0;
				constraintsJTextFieldDAI3.insets = new java.awt.Insets(4, 4, 4, 4);
				getJPanelDAI().add(getJTextFieldDAI3(), constraintsJTextFieldDAI3);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelDAI;
	}
	/**
	 * Return the JPanel3 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelDIO() {
		if (ivjJPanelDIO == null) {
			try {
				ivjJPanelDIO = new javax.swing.JPanel();
				ivjJPanelDIO.setName("JPanelDIO");
				ivjJPanelDIO.setPreferredSize(new java.awt.Dimension(80, 460));
				ivjJPanelDIO.setLayout(new java.awt.BorderLayout());
				ivjJPanelDIO.setBounds(0, 0, 84, 708);
				ivjJPanelDIO.setMinimumSize(new java.awt.Dimension(80, 200));
				getJPanelDIO().add(getpIO(), "North");
				getJPanelDIO().add(getpD(), "South");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelDIO;
	}
	/**
	 * Return the JPanel1 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJPanelStatus() {
		if (ivjJPanelStatus == null) {
			try {
				ivjJPanelStatus = new javax.swing.JPanel();
				ivjJPanelStatus.setName("JPanelStatus");
				ivjJPanelStatus.setLayout(new java.awt.FlowLayout());
				getJPanelStatus().add(getJLabelCounter(), getJLabelCounter().getName());
				getJPanelStatus().add(getJTextFieldCounter(), getJTextFieldCounter().getName());
				getJPanelStatus().add(getJButtonCounterReset(), getJButtonCounterReset().getName());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJPanelStatus;
	}
	/**
	 * Return the JScrollPane1 property value.
	 * @return javax.swing.JScrollPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JScrollPane getJScrollPaneDIO() {
		if (ivjJScrollPaneDIO == null) {
			try {
				ivjJScrollPaneDIO = new javax.swing.JScrollPane();
				ivjJScrollPaneDIO.setName("JScrollPaneDIO");
				ivjJScrollPaneDIO.setPreferredSize(new java.awt.Dimension(100, 420));
				getJScrollPaneDIO().setViewportView(getJPanelDIO());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJScrollPaneDIO;
	}
	/**
	 * Return the JSliderAO0 property value.
	 * @return javax.swing.JSlider
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSlider getJSliderAO0() {
		if (ivjJSliderAO0 == null) {
			try {
				ivjJSliderAO0 = new javax.swing.JSlider();
				ivjJSliderAO0.setName("JSliderAO0");
				ivjJSliderAO0.setMaximum(500);
				ivjJSliderAO0.setValue(0);
				// user code begin {1}
				this.sAOs[0] = ivjJSliderAO0;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSliderAO0;
	}
	/**
	 * Return the JSliderAO1 property value.
	 * @return javax.swing.JSlider
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JSlider getJSliderAO1() {
		if (ivjJSliderAO1 == null) {
			try {
				ivjJSliderAO1 = new javax.swing.JSlider();
				ivjJSliderAO1.setName("JSliderAO1");
				ivjJSliderAO1.setMajorTickSpacing(0);
				ivjJSliderAO1.setMaximum(500);
				ivjJSliderAO1.setValue(0);
				// user code begin {1}
				this.sAOs[1] = ivjJSliderAO1;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJSliderAO1;
	}
	/**
	 * Return the JTextFieldAI0 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI0() {
		if (ivjJTextFieldAI0 == null) {
			try {
				ivjJTextFieldAI0 = new javax.swing.JTextField();
				ivjJTextFieldAI0.setName("JTextFieldAI0");
				ivjJTextFieldAI0.setEditable(false);
				// user code begin {1}
				this.tfAIs[0] = ivjJTextFieldAI0;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI0;
	}
	/**
	 * Return the JTextFieldAI1 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI1() {
		if (ivjJTextFieldAI1 == null) {
			try {
				ivjJTextFieldAI1 = new javax.swing.JTextField();
				ivjJTextFieldAI1.setName("JTextFieldAI1");
				ivjJTextFieldAI1.setEditable(false);
				// user code begin {1}
				this.tfAIs[1] = ivjJTextFieldAI1;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI1;
	}
	/**
	 * Return the JTextFieldAI2 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI2() {
		if (ivjJTextFieldAI2 == null) {
			try {
				ivjJTextFieldAI2 = new javax.swing.JTextField();
				ivjJTextFieldAI2.setName("JTextFieldAI2");
				ivjJTextFieldAI2.setEditable(false);
				// user code begin {1}
				this.tfAIs[2] = ivjJTextFieldAI2;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI2;
	}
	/**
	 * Return the JTextFieldAI3 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI3() {
		if (ivjJTextFieldAI3 == null) {
			try {
				ivjJTextFieldAI3 = new javax.swing.JTextField();
				ivjJTextFieldAI3.setName("JTextFieldAI3");
				ivjJTextFieldAI3.setEditable(false);
				// user code begin {1}
				this.tfAIs[3] = ivjJTextFieldAI3;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI3;
	}
	/**
	 * Return the JTextFieldAI4 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI4() {
		if (ivjJTextFieldAI4 == null) {
			try {
				ivjJTextFieldAI4 = new javax.swing.JTextField();
				ivjJTextFieldAI4.setName("JTextFieldAI4");
				ivjJTextFieldAI4.setEditable(false);
				// user code begin {1}
				this.tfAIs[4] = ivjJTextFieldAI4;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI4;
	}
	/**
	 * Return the JTextFieldAI5 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI5() {
		if (ivjJTextFieldAI5 == null) {
			try {
				ivjJTextFieldAI5 = new javax.swing.JTextField();
				ivjJTextFieldAI5.setName("JTextFieldAI5");
				ivjJTextFieldAI5.setEditable(false);
				// user code begin {1}
				this.tfAIs[5] = ivjJTextFieldAI5;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI5;
	}
	/**
	 * Return the JTextFieldAI6 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI6() {
		if (ivjJTextFieldAI6 == null) {
			try {
				ivjJTextFieldAI6 = new javax.swing.JTextField();
				ivjJTextFieldAI6.setName("JTextFieldAI6");
				ivjJTextFieldAI6.setEditable(false);
				// user code begin {1}
				this.tfAIs[6] = ivjJTextFieldAI6;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI6;
	}
	/**
	 * Return the JTextFieldAI7 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAI7() {
		if (ivjJTextFieldAI7 == null) {
			try {
				ivjJTextFieldAI7 = new javax.swing.JTextField();
				ivjJTextFieldAI7.setName("JTextFieldAI7");
				ivjJTextFieldAI7.setEditable(false);
				// user code begin {1}
				this.tfAIs[7] = ivjJTextFieldAI7;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAI7;
	}
	/**
	 * Return the JTextFieldAO0 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAO0() {
		if (ivjJTextFieldAO0 == null) {
			try {
				ivjJTextFieldAO0 = new javax.swing.JTextField();
				ivjJTextFieldAO0.setName("JTextFieldAO0");
				ivjJTextFieldAO0.setPreferredSize(new java.awt.Dimension(100, 20));
				ivjJTextFieldAO0.setText("0.0");
				ivjJTextFieldAO0.setMinimumSize(new java.awt.Dimension(100, 20));
				// user code begin {1}
				this.tfAOs[0] = ivjJTextFieldAO0;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAO0;
	}
	/**
	 * Return the JTextFieldAO1 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldAO1() {
		if (ivjJTextFieldAO1 == null) {
			try {
				ivjJTextFieldAO1 = new javax.swing.JTextField();
				ivjJTextFieldAO1.setName("JTextFieldAO1");
				ivjJTextFieldAO1.setText("0.0");
				// user code begin {1}
				this.tfAOs[1] = ivjJTextFieldAO1;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldAO1;
	}
	/**
	 * Return the JTextField1 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldCounter() {
		if (ivjJTextFieldCounter == null) {
			try {
				ivjJTextFieldCounter = new javax.swing.JTextField();
				ivjJTextFieldCounter.setName("JTextFieldCounter");
				ivjJTextFieldCounter.setPreferredSize(new java.awt.Dimension(100, 20));
				ivjJTextFieldCounter.setMinimumSize(new java.awt.Dimension(100, 20));
				ivjJTextFieldCounter.setEditable(false);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldCounter;
	}
	/**
	 * Return the JTextFieldDAI0 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldDAI0() {
		if (ivjJTextFieldDAI0 == null) {
			try {
				ivjJTextFieldDAI0 = new javax.swing.JTextField();
				ivjJTextFieldDAI0.setName("JTextFieldDAI0");
				ivjJTextFieldDAI0.setPreferredSize(new java.awt.Dimension(80, 20));
				ivjJTextFieldDAI0.setEditable(false);
				ivjJTextFieldDAI0.setMinimumSize(new java.awt.Dimension(80, 20));
				// user code begin {1}
				this.tfDAIs[0] = ivjJTextFieldDAI0;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldDAI0;
	}
	/**
	 * Return the JTextFieldDAI1 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldDAI1() {
		if (ivjJTextFieldDAI1 == null) {
			try {
				ivjJTextFieldDAI1 = new javax.swing.JTextField();
				ivjJTextFieldDAI1.setName("JTextFieldDAI1");
				ivjJTextFieldDAI1.setPreferredSize(new java.awt.Dimension(80, 20));
				ivjJTextFieldDAI1.setEditable(false);
				ivjJTextFieldDAI1.setMinimumSize(new java.awt.Dimension(80, 20));
				// user code begin {1}
				this.tfDAIs[1] = ivjJTextFieldDAI1;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldDAI1;
	}
	/**
	 * Return the JTextFieldDAI2 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldDAI2() {
		if (ivjJTextFieldDAI2 == null) {
			try {
				ivjJTextFieldDAI2 = new javax.swing.JTextField();
				ivjJTextFieldDAI2.setName("JTextFieldDAI2");
				ivjJTextFieldDAI2.setPreferredSize(new java.awt.Dimension(80, 20));
				ivjJTextFieldDAI2.setEditable(false);
				ivjJTextFieldDAI2.setMinimumSize(new java.awt.Dimension(80, 20));
				// user code begin {1}
				this.tfDAIs[2] = ivjJTextFieldDAI2;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldDAI2;
	}
	/**
	 * Return the JTextFieldDAI3 property value.
	 * @return javax.swing.JTextField
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JTextField getJTextFieldDAI3() {
		if (ivjJTextFieldDAI3 == null) {
			try {
				ivjJTextFieldDAI3 = new javax.swing.JTextField();
				ivjJTextFieldDAI3.setName("JTextFieldDAI3");
				ivjJTextFieldDAI3.setPreferredSize(new java.awt.Dimension(80, 20));
				ivjJTextFieldDAI3.setEditable(false);
				ivjJTextFieldDAI3.setMinimumSize(new java.awt.Dimension(80, 20));
				// user code begin {1}
				this.tfDAIs[3] = ivjJTextFieldDAI3;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJTextFieldDAI3;
	}
	/**
	 * Insert the method's description here.
	 * @created (2/8/2003 12:29:56 AM)
	 * @return com.teravation.labjack.LabJack
	 */
	public com.teravation.labjack.LabJack getLabJack() {
		return labjack;
	}
	/**
	 * Return the JPanel1 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getpD() {
		if (ivjpD == null) {
			try {
				ivjpD = new javax.swing.JPanel();
				ivjpD.setName("pD");
				ivjpD.setPreferredSize(new java.awt.Dimension(70, 420));
				ivjpD.setLayout(new java.awt.GridBagLayout());
				ivjpD.setMinimumSize(new java.awt.Dimension(70, 200));

				java.awt.GridBagConstraints constraintscbD00 = new java.awt.GridBagConstraints();
				constraintscbD00.gridx = 0;
				constraintscbD00.gridy = 0;
				constraintscbD00.insets = new java.awt.Insets(2, 2, 2, 2);
				getpD().add(getcbD00(), constraintscbD00);

				java.awt.GridBagConstraints constraintscbD01 = new java.awt.GridBagConstraints();
				constraintscbD01.gridx = 0;
				constraintscbD01.gridy = 1;
				constraintscbD01.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD01(), constraintscbD01);

				java.awt.GridBagConstraints constraintscbD02 = new java.awt.GridBagConstraints();
				constraintscbD02.gridx = 0;
				constraintscbD02.gridy = 2;
				constraintscbD02.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD02(), constraintscbD02);

				java.awt.GridBagConstraints constraintscbD03 = new java.awt.GridBagConstraints();
				constraintscbD03.gridx = 0;
				constraintscbD03.gridy = 3;
				constraintscbD03.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD03(), constraintscbD03);

				java.awt.GridBagConstraints constraintscbD04 = new java.awt.GridBagConstraints();
				constraintscbD04.gridx = 0;
				constraintscbD04.gridy = 4;
				constraintscbD04.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD04(), constraintscbD04);

				java.awt.GridBagConstraints constraintscbD05 = new java.awt.GridBagConstraints();
				constraintscbD05.gridx = 0;
				constraintscbD05.gridy = 5;
				constraintscbD05.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD05(), constraintscbD05);

				java.awt.GridBagConstraints constraintscbD06 = new java.awt.GridBagConstraints();
				constraintscbD06.gridx = 0;
				constraintscbD06.gridy = 6;
				constraintscbD06.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD06(), constraintscbD06);

				java.awt.GridBagConstraints constraintscbD07 = new java.awt.GridBagConstraints();
				constraintscbD07.gridx = 0;
				constraintscbD07.gridy = 7;
				constraintscbD07.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD07(), constraintscbD07);

				java.awt.GridBagConstraints constraintscbD08 = new java.awt.GridBagConstraints();
				constraintscbD08.gridx = 0;
				constraintscbD08.gridy = 8;
				constraintscbD08.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD08(), constraintscbD08);

				java.awt.GridBagConstraints constraintscbD09 = new java.awt.GridBagConstraints();
				constraintscbD09.gridx = 0;
				constraintscbD09.gridy = 9;
				constraintscbD09.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD09(), constraintscbD09);

				java.awt.GridBagConstraints constraintscbD10 = new java.awt.GridBagConstraints();
				constraintscbD10.gridx = 0;
				constraintscbD10.gridy = 10;
				constraintscbD10.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD10(), constraintscbD10);

				java.awt.GridBagConstraints constraintscbD11 = new java.awt.GridBagConstraints();
				constraintscbD11.gridx = 0;
				constraintscbD11.gridy = 11;
				constraintscbD11.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD11(), constraintscbD11);

				java.awt.GridBagConstraints constraintscbD12 = new java.awt.GridBagConstraints();
				constraintscbD12.gridx = 0;
				constraintscbD12.gridy = 12;
				constraintscbD12.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD12(), constraintscbD12);

				java.awt.GridBagConstraints constraintscbD13 = new java.awt.GridBagConstraints();
				constraintscbD13.gridx = 0;
				constraintscbD13.gridy = 13;
				constraintscbD13.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD13(), constraintscbD13);

				java.awt.GridBagConstraints constraintscbD14 = new java.awt.GridBagConstraints();
				constraintscbD14.gridx = 0;
				constraintscbD14.gridy = 14;
				constraintscbD14.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD14(), constraintscbD14);

				java.awt.GridBagConstraints constraintscbD15 = new java.awt.GridBagConstraints();
				constraintscbD15.gridx = 0;
				constraintscbD15.gridy = 15;
				constraintscbD15.insets = new java.awt.Insets(4, 4, 4, 4);
				getpD().add(getcbD15(), constraintscbD15);

				java.awt.GridBagConstraints constraintsrbD00 = new java.awt.GridBagConstraints();
				constraintsrbD00.gridx = 1;
				constraintsrbD00.gridy = 0;
				constraintsrbD00.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD00(), constraintsrbD00);

				java.awt.GridBagConstraints constraintsrbD01 = new java.awt.GridBagConstraints();
				constraintsrbD01.gridx = 1;
				constraintsrbD01.gridy = 1;
				constraintsrbD01.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD01(), constraintsrbD01);

				java.awt.GridBagConstraints constraintsrbD02 = new java.awt.GridBagConstraints();
				constraintsrbD02.gridx = 1;
				constraintsrbD02.gridy = 2;
				constraintsrbD02.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD02(), constraintsrbD02);

				java.awt.GridBagConstraints constraintsrbD03 = new java.awt.GridBagConstraints();
				constraintsrbD03.gridx = 1;
				constraintsrbD03.gridy = 3;
				constraintsrbD03.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD03(), constraintsrbD03);

				java.awt.GridBagConstraints constraintsrbD04 = new java.awt.GridBagConstraints();
				constraintsrbD04.gridx = 1;
				constraintsrbD04.gridy = 4;
				constraintsrbD04.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD04(), constraintsrbD04);

				java.awt.GridBagConstraints constraintsrbD05 = new java.awt.GridBagConstraints();
				constraintsrbD05.gridx = 1;
				constraintsrbD05.gridy = 5;
				constraintsrbD05.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD05(), constraintsrbD05);

				java.awt.GridBagConstraints constraintsrbD06 = new java.awt.GridBagConstraints();
				constraintsrbD06.gridx = 1;
				constraintsrbD06.gridy = 6;
				constraintsrbD06.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD06(), constraintsrbD06);

				java.awt.GridBagConstraints constraintsrbD07 = new java.awt.GridBagConstraints();
				constraintsrbD07.gridx = 1;
				constraintsrbD07.gridy = 7;
				constraintsrbD07.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD07(), constraintsrbD07);

				java.awt.GridBagConstraints constraintsrbD08 = new java.awt.GridBagConstraints();
				constraintsrbD08.gridx = 1;
				constraintsrbD08.gridy = 8;
				constraintsrbD08.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD08(), constraintsrbD08);

				java.awt.GridBagConstraints constraintsrbD09 = new java.awt.GridBagConstraints();
				constraintsrbD09.gridx = 1;
				constraintsrbD09.gridy = 9;
				constraintsrbD09.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD09(), constraintsrbD09);

				java.awt.GridBagConstraints constraintsrbD10 = new java.awt.GridBagConstraints();
				constraintsrbD10.gridx = 1;
				constraintsrbD10.gridy = 10;
				constraintsrbD10.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD10(), constraintsrbD10);

				java.awt.GridBagConstraints constraintsrbD11 = new java.awt.GridBagConstraints();
				constraintsrbD11.gridx = 1;
				constraintsrbD11.gridy = 11;
				constraintsrbD11.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD11(), constraintsrbD11);

				java.awt.GridBagConstraints constraintsrbD12 = new java.awt.GridBagConstraints();
				constraintsrbD12.gridx = 1;
				constraintsrbD12.gridy = 12;
				constraintsrbD12.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD12(), constraintsrbD12);

				java.awt.GridBagConstraints constraintsrbD13 = new java.awt.GridBagConstraints();
				constraintsrbD13.gridx = 1;
				constraintsrbD13.gridy = 13;
				constraintsrbD13.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD13(), constraintsrbD13);

				java.awt.GridBagConstraints constraintsrbD14 = new java.awt.GridBagConstraints();
				constraintsrbD14.gridx = 1;
				constraintsrbD14.gridy = 14;
				constraintsrbD14.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD14(), constraintsrbD14);

				java.awt.GridBagConstraints constraintsrbD15 = new java.awt.GridBagConstraints();
				constraintsrbD15.gridx = 1;
				constraintsrbD15.gridy = 15;
				constraintsrbD15.insets = new java.awt.Insets(2, 0, 2, 2);
				getpD().add(getrbD15(), constraintsrbD15);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjpD;
	}
	/**
	 * Return the JPanel11 property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getpIO() {
		if (ivjpIO == null) {
			try {
				ivjpIO = new javax.swing.JPanel();
				ivjpIO.setName("pIO");
				ivjpIO.setPreferredSize(new java.awt.Dimension(70, 120));
				ivjpIO.setLayout(new java.awt.GridBagLayout());
				ivjpIO.setMinimumSize(new java.awt.Dimension(70, 120));

				java.awt.GridBagConstraints constraintscbIO00 = new java.awt.GridBagConstraints();
				constraintscbIO00.gridx = 0;
				constraintscbIO00.gridy = 1;
				constraintscbIO00.insets = new java.awt.Insets(2, 2, 2, 2);
				getpIO().add(getcbIO00(), constraintscbIO00);

				java.awt.GridBagConstraints constraintscbIO01 = new java.awt.GridBagConstraints();
				constraintscbIO01.gridx = 0;
				constraintscbIO01.gridy = 2;
				constraintscbIO01.insets = new java.awt.Insets(2, 2, 2, 2);
				getpIO().add(getcbIO01(), constraintscbIO01);

				java.awt.GridBagConstraints constraintscbIO02 = new java.awt.GridBagConstraints();
				constraintscbIO02.gridx = 0;
				constraintscbIO02.gridy = 3;
				constraintscbIO02.insets = new java.awt.Insets(2, 2, 2, 2);
				getpIO().add(getcbIO02(), constraintscbIO02);

				java.awt.GridBagConstraints constraintscbIO03 = new java.awt.GridBagConstraints();
				constraintscbIO03.gridx = 0;
				constraintscbIO03.gridy = 4;
				constraintscbIO03.insets = new java.awt.Insets(2, 2, 2, 2);
				getpIO().add(getcbIO03(), constraintscbIO03);

				java.awt.GridBagConstraints constraintsrbIO00 = new java.awt.GridBagConstraints();
				constraintsrbIO00.gridx = 1;
				constraintsrbIO00.gridy = 1;
				constraintsrbIO00.insets = new java.awt.Insets(2, 0, 2, 2);
				getpIO().add(getrbIO00(), constraintsrbIO00);

				java.awt.GridBagConstraints constraintsrbIO01 = new java.awt.GridBagConstraints();
				constraintsrbIO01.gridx = 1;
				constraintsrbIO01.gridy = 2;
				constraintsrbIO01.insets = new java.awt.Insets(2, 0, 2, 2);
				getpIO().add(getrbIO01(), constraintsrbIO01);

				java.awt.GridBagConstraints constraintsrbIO02 = new java.awt.GridBagConstraints();
				constraintsrbIO02.gridx = 1;
				constraintsrbIO02.gridy = 3;
				constraintsrbIO02.insets = new java.awt.Insets(2, 0, 2, 2);
				getpIO().add(getrbIO02(), constraintsrbIO02);

				java.awt.GridBagConstraints constraintsrbIO03 = new java.awt.GridBagConstraints();
				constraintsrbIO03.gridx = 1;
				constraintsrbIO03.gridy = 4;
				constraintsrbIO03.insets = new java.awt.Insets(2, 0, 2, 2);
				getpIO().add(getrbIO03(), constraintsrbIO03);

				java.awt.GridBagConstraints constraintsJLabelDirection = new java.awt.GridBagConstraints();
				constraintsJLabelDirection.gridx = 0;
				constraintsJLabelDirection.gridy = 0;
				constraintsJLabelDirection.insets = new java.awt.Insets(4, 4, 4, 4);
				getpIO().add(getJLabelDirection(), constraintsJLabelDirection);
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjpIO;
	}
	/**
	 * Return the rbDO property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD00() {
		if (ivjrbD00 == null) {
			try {
				ivjrbD00 = new javax.swing.JRadioButton();
				ivjrbD00.setName("rbD00");
				ivjrbD00.setText("D0");
				ivjrbD00.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD00.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD00.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD00.setEnabled(false);
				ivjrbD00.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[0] = ivjrbD00;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD00;
	}
	/**
	 * Return the rbD1 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD01() {
		if (ivjrbD01 == null) {
			try {
				ivjrbD01 = new javax.swing.JRadioButton();
				ivjrbD01.setName("rbD01");
				ivjrbD01.setText("D1");
				ivjrbD01.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD01.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD01.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD01.setEnabled(false);
				ivjrbD01.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[1] = ivjrbD01;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD01;
	}
	/**
	 * Return the rbD2 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD02() {
		if (ivjrbD02 == null) {
			try {
				ivjrbD02 = new javax.swing.JRadioButton();
				ivjrbD02.setName("rbD02");
				ivjrbD02.setText("D2");
				ivjrbD02.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD02.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD02.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD02.setEnabled(false);
				ivjrbD02.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[2] = ivjrbD02;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD02;
	}
	/**
	 * Return the rbD3 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD03() {
		if (ivjrbD03 == null) {
			try {
				ivjrbD03 = new javax.swing.JRadioButton();
				ivjrbD03.setName("rbD03");
				ivjrbD03.setText("D3");
				ivjrbD03.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD03.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD03.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD03.setEnabled(false);
				ivjrbD03.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[3] = ivjrbD03;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD03;
	}
	/**
	 * Return the rbD4 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD04() {
		if (ivjrbD04 == null) {
			try {
				ivjrbD04 = new javax.swing.JRadioButton();
				ivjrbD04.setName("rbD04");
				ivjrbD04.setText("D4");
				ivjrbD04.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD04.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD04.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD04.setEnabled(false);
				ivjrbD04.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[4] = ivjrbD04;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD04;
	}
	/**
	 * Return the rbD5 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD05() {
		if (ivjrbD05 == null) {
			try {
				ivjrbD05 = new javax.swing.JRadioButton();
				ivjrbD05.setName("rbD05");
				ivjrbD05.setText("D5");
				ivjrbD05.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD05.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD05.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD05.setEnabled(false);
				ivjrbD05.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[5] = ivjrbD05;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD05;
	}
	/**
	 * Return the rbD6 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD06() {
		if (ivjrbD06 == null) {
			try {
				ivjrbD06 = new javax.swing.JRadioButton();
				ivjrbD06.setName("rbD06");
				ivjrbD06.setText("D6");
				ivjrbD06.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD06.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD06.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD06.setEnabled(false);
				ivjrbD06.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[6] = ivjrbD06;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD06;
	}
	/**
	 * Return the rbD7 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD07() {
		if (ivjrbD07 == null) {
			try {
				ivjrbD07 = new javax.swing.JRadioButton();
				ivjrbD07.setName("rbD07");
				ivjrbD07.setText("D7");
				ivjrbD07.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD07.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD07.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD07.setEnabled(false);
				ivjrbD07.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[7] = ivjrbD07;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD07;
	}
	/**
	 * Return the rbD8 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD08() {
		if (ivjrbD08 == null) {
			try {
				ivjrbD08 = new javax.swing.JRadioButton();
				ivjrbD08.setName("rbD08");
				ivjrbD08.setText("D8");
				ivjrbD08.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD08.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD08.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD08.setEnabled(false);
				ivjrbD08.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[8] = ivjrbD08;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD08;
	}
	/**
	 * Return the rbD9 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD09() {
		if (ivjrbD09 == null) {
			try {
				ivjrbD09 = new javax.swing.JRadioButton();
				ivjrbD09.setName("rbD09");
				ivjrbD09.setText("D9");
				ivjrbD09.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD09.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD09.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD09.setEnabled(false);
				ivjrbD09.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[9] = ivjrbD09;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD09;
	}
	/**
	 * Return the rbD10 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD10() {
		if (ivjrbD10 == null) {
			try {
				ivjrbD10 = new javax.swing.JRadioButton();
				ivjrbD10.setName("rbD10");
				ivjrbD10.setText("D10");
				ivjrbD10.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD10.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD10.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD10.setEnabled(false);
				ivjrbD10.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[10] = ivjrbD10;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD10;
	}
	/**
	 * Return the rbD11 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD11() {
		if (ivjrbD11 == null) {
			try {
				ivjrbD11 = new javax.swing.JRadioButton();
				ivjrbD11.setName("rbD11");
				ivjrbD11.setText("D11");
				ivjrbD11.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD11.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD11.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD11.setEnabled(false);
				ivjrbD11.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[11] = ivjrbD11;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD11;
	}
	/**
	 * Return the rbD12 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD12() {
		if (ivjrbD12 == null) {
			try {
				ivjrbD12 = new javax.swing.JRadioButton();
				ivjrbD12.setName("rbD12");
				ivjrbD12.setText("D12");
				ivjrbD12.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD12.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD12.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD12.setEnabled(false);
				ivjrbD12.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[12] = ivjrbD12;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD12;
	}
	/**
	 * Return the rbD13 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD13() {
		if (ivjrbD13 == null) {
			try {
				ivjrbD13 = new javax.swing.JRadioButton();
				ivjrbD13.setName("rbD13");
				ivjrbD13.setText("D13");
				ivjrbD13.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD13.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD13.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD13.setEnabled(false);
				ivjrbD13.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[13] = ivjrbD13;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD13;
	}
	/**
	 * Return the rbD14 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD14() {
		if (ivjrbD14 == null) {
			try {
				ivjrbD14 = new javax.swing.JRadioButton();
				ivjrbD14.setName("rbD14");
				ivjrbD14.setText("D14");
				ivjrbD14.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbD14.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbD14.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbD14.setEnabled(false);
				ivjrbD14.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[14] = ivjrbD14;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD14;
	}
	/**
	 * Return the rbD15 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbD15() {
		if (ivjrbD15 == null) {
			try {
				ivjrbD15 = new javax.swing.JRadioButton();
				ivjrbD15.setName("rbD15");
				ivjrbD15.setText("D15");
				ivjrbD15.setMaximumSize(new java.awt.Dimension(50, 20));
				ivjrbD15.setPreferredSize(new java.awt.Dimension(50, 20));
				ivjrbD15.setMinimumSize(new java.awt.Dimension(50, 20));
				ivjrbD15.setEnabled(false);
				ivjrbD15.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbDs[15] = ivjrbD15;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbD15;
	}
	/**
	 * Return the rbIO0 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbIO00() {
		if (ivjrbIO00 == null) {
			try {
				ivjrbIO00 = new javax.swing.JRadioButton();
				ivjrbIO00.setName("rbIO00");
				ivjrbIO00.setText("IO0");
				ivjrbIO00.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbIO00.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbIO00.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbIO00.setEnabled(false);
				ivjrbIO00.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbIOs[0] = ivjrbIO00;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbIO00;
	}
	/**
	 * Return the rbIO1 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbIO01() {
		if (ivjrbIO01 == null) {
			try {
				ivjrbIO01 = new javax.swing.JRadioButton();
				ivjrbIO01.setName("rbIO01");
				ivjrbIO01.setText("IO1");
				ivjrbIO01.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbIO01.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbIO01.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbIO01.setEnabled(false);
				ivjrbIO01.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbIOs[1] = ivjrbIO01;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbIO01;
	}
	/**
	 * Return the rbIO2 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbIO02() {
		if (ivjrbIO02 == null) {
			try {
				ivjrbIO02 = new javax.swing.JRadioButton();
				ivjrbIO02.setName("rbIO02");
				ivjrbIO02.setText("IO2");
				ivjrbIO02.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbIO02.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbIO02.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbIO02.setEnabled(false);
				ivjrbIO02.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbIOs[2] = ivjrbIO02;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbIO02;
	}
	/**
	 * Return the rbIO3 property value.
	 * @return javax.swing.JRadioButton
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JRadioButton getrbIO03() {
		if (ivjrbIO03 == null) {
			try {
				ivjrbIO03 = new javax.swing.JRadioButton();
				ivjrbIO03.setName("rbIO03");
				ivjrbIO03.setText("IO3");
				ivjrbIO03.setMaximumSize(new java.awt.Dimension(50,20));
				ivjrbIO03.setPreferredSize(new java.awt.Dimension(50,20));
				ivjrbIO03.setMinimumSize(new java.awt.Dimension(50,20));
				ivjrbIO03.setEnabled(false);
				ivjrbIO03.setMargin(new java.awt.Insets(0, 0, 0, 0));
				// user code begin {1}
				this.rbIOs[3] = ivjrbIO03;
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjrbIO03;
	}
	/**
	 * Called whenever the part throws an exception.
	 * @param exception java.lang.Throwable
	 */
	private void handleException(java.lang.Throwable exception) {

		/* Uncomment the following lines to print uncaught exceptions to stdout */
		// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
		// exception.printStackTrace(System.out);
	}
	/**
	 * Initializes connections
	 * @exception java.lang.Exception The exception description.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initConnections() throws java.lang.Exception {
		// user code begin {1}
		// user code end
		getcbIO00().addActionListener(ivjEventHandler);
		getcbIO01().addActionListener(ivjEventHandler);
		getcbIO02().addActionListener(ivjEventHandler);
		getcbIO03().addActionListener(ivjEventHandler);
		getrbIO00().addActionListener(ivjEventHandler);
		getrbIO01().addActionListener(ivjEventHandler);
		getrbIO02().addActionListener(ivjEventHandler);
		getrbIO03().addActionListener(ivjEventHandler);
		getJButtonCounterReset().addActionListener(ivjEventHandler);
		getcbD00().addActionListener(ivjEventHandler);
		getcbD01().addActionListener(ivjEventHandler);
		getcbD02().addActionListener(ivjEventHandler);
		getcbD03().addActionListener(ivjEventHandler);
		getcbD04().addActionListener(ivjEventHandler);
		getcbD05().addActionListener(ivjEventHandler);
		getcbD06().addActionListener(ivjEventHandler);
		getcbD07().addActionListener(ivjEventHandler);
		getcbD08().addActionListener(ivjEventHandler);
		getcbD09().addActionListener(ivjEventHandler);
		getcbD10().addActionListener(ivjEventHandler);
		getcbD11().addActionListener(ivjEventHandler);
		getcbD12().addActionListener(ivjEventHandler);
		getcbD13().addActionListener(ivjEventHandler);
		getcbD14().addActionListener(ivjEventHandler);
		getcbD15().addActionListener(ivjEventHandler);
		getrbD15().addActionListener(ivjEventHandler);
		getrbD14().addActionListener(ivjEventHandler);
		getrbD13().addActionListener(ivjEventHandler);
		getrbD12().addActionListener(ivjEventHandler);
		getrbD11().addActionListener(ivjEventHandler);
		getrbD10().addActionListener(ivjEventHandler);
		getrbD09().addActionListener(ivjEventHandler);
		getrbD08().addActionListener(ivjEventHandler);
		getrbD07().addActionListener(ivjEventHandler);
		getrbD06().addActionListener(ivjEventHandler);
		getrbD05().addActionListener(ivjEventHandler);
		getrbD04().addActionListener(ivjEventHandler);
		getrbD03().addActionListener(ivjEventHandler);
		getrbD02().addActionListener(ivjEventHandler);
		getrbD01().addActionListener(ivjEventHandler);
		getrbD00().addActionListener(ivjEventHandler);
		getJTextFieldAO0().addFocusListener(ivjEventHandler);
		getJSliderAO0().addChangeListener(ivjEventHandler);
		getJSliderAO1().addChangeListener(ivjEventHandler);
		getJTextFieldAO1().addFocusListener(ivjEventHandler);
		getJComboBoxDAI0().addActionListener(ivjEventHandler);
		getJComboBoxDAI1().addActionListener(ivjEventHandler);
		getJComboBoxDAI2().addActionListener(ivjEventHandler);
		getJComboBoxDAI3().addActionListener(ivjEventHandler);
		this.addWindowListener(ivjEventHandler);
	}
	/**
	 * Initialize the class.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initialize() {
		try {
			// user code begin {1}
			// user code end
			setName("LabJackDemoFrame");
			setDefaultCloseOperation(2);
			setBounds(new java.awt.Rectangle(0, 0, 426, 240));
			setSize(350, 538);
			setContentPane(getJFrameContentPane());
			initConnections();
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
		// user code begin {2}
		this.setTitle(this.getLabJack().toString());
		// user code end
	}
	/**
	 * Comment
	 */
	public void jButtonCounterReset_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
		this.resetCounter = true;
	}
	/**
	 * Comment
	 */
	public void jComboBoxDAI_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
		JComboBox changedComboBox = (JComboBox) actionEvent.getSource();
		String channelString = changedComboBox.getName().substring(changedComboBox.getName().length() - 1);
		int channel = Integer.parseInt(channelString);

		try {
			this.getLabJack().setDifferentialAIGain(channel, changedComboBox.getSelectedIndex());
		} catch (LabJackException lje) {
			lje.printStackTrace(System.err);
		}

	}
	/**
	 * Comment
	 */
	public void jSliderAO_StateChanged(javax.swing.event.ChangeEvent stateChangeEvent) {
		JSlider changedSlider = (JSlider) stateChangeEvent.getSource();
		String channelString = changedSlider.getName().substring(changedSlider.getName().length() - 1);
		int channel = Integer.parseInt(channelString);

		float newValue = (changedSlider.getValue() / 100.0f);
		this.tfAOs[channel].setText("" + newValue);
		try {
			this.getLabJack().setAO(channel, newValue);
		} catch (LabJackException lje) {
			lje.printStackTrace(System.err);
		}
	}
	/**
	 * Comment
	 */
	public void jTextFieldAO_FocusLost(java.awt.event.FocusEvent focusEvent) {
		JTextField changedTextField = (JTextField) focusEvent.getSource();
		String channelString = changedTextField.getName().substring(changedTextField.getName().length() - 1);
		int channel = Integer.parseInt(channelString);

		try {
			float newValue = Float.parseFloat(changedTextField.getText());
			this.sAOs[channel].setValue((int) (100 * newValue));
			try {
				this.getLabJack().setAO(channel, newValue);
			} catch (LabJackException lje) {
				lje.printStackTrace(System.err);
			}
		} catch (NumberFormatException nfe) {
		}
	}
	/**
	 * Comment
	 */
	public void labJackDemoFrame_WindowClosing(java.awt.event.WindowEvent windowEvent) {
		updateThread.stopRunning();
	}
	/**
	 * Comment
	 */
	public void rbD_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
		JRadioButton rbSelected = (JRadioButton) actionEvent.getSource();

		String channelString = rbSelected.getName().substring(rbSelected.getName().length() - 2);
		int channel = Integer.parseInt(channelString);
		//    JCheckBox cbSelected = cbDs[channel];
		try {
			this.getLabJack().setD(channel, rbSelected.isSelected());
			//        this.getLabJack().updateD(channel);
		} catch (LabJackException lje) {
			lje.printStackTrace(System.err);
		}
	}
	/**
	 * Comment
	 */
	public void rbIO_ActionPerformed(java.awt.event.ActionEvent actionEvent) {
		JRadioButton rbSelected = (JRadioButton) actionEvent.getSource();

		String channelString = rbSelected.getName().substring(rbSelected.getName().length() - 2);
		int channel = Integer.parseInt(channelString);
		//    JCheckBox cbSelected = cbIOs[channel];
		try {
			this.getLabJack().setIO(channel, rbSelected.isSelected());
			//        this.getLabJack().updateIO(channel);
		} catch (LabJackException lje) {
			lje.printStackTrace(System.err);
		}
	}
	/**
	 * Set the Labjack object to monitored
	 * @created (2/8/2003 12:29:56 AM)
	 * @param newLabjack com.teravation.labjack.LabJack
	 */
	private void setLabJack(com.teravation.labjack.LabJack newLabjack) {
		labjack = newLabjack;
	}
}
