package com.teravation.labjack.monitor;

import java.awt.Point;
import javax.swing.DefaultListModel;
import com.teravation.labjack.*;

/**
 * This file is part of LabJackJava.  Copyright 2003-2004, Teravation.  All rights reserved. 
 * 
 * LabJackJava is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * LabJackJava is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with LabJackJava;
 * if not, write to:
 *    Free Software Foundation, Inc.
 *    59 Temple Place, Suite 330
 *    Boston, MA  02111-1307  USA
 * 
 * In addition, as a special exception, Teravation gives permission to link the code of this program with
 * the LabJack C driver (or with modified versions of the LabJack C driver that use the same license),
 * and distribute linked combinations including the two.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the LabJack C driver.  If you modify this file, you may 
 * extend this exception to your version of the file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 */

/**
 * The selection frame allows the user to select which LabJack to monitor from all available LabJacks.  It is the 
 * entry point (main) to the Monitoring application.
 *
 * <p />Copyright &copy; 2003-2004 <a href="http://www.teravation.com">Teravation</a>. All rights reserved.
 * 
 * @created (2/7/2003 11:38:36 PM)
 * @version 4.0
 * @author Chris Reigrut 
 */
public class LabJackSelectionFrame extends javax.swing.JFrame {
	private javax.swing.JPanel ivjJFrameContentPane = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private LabJackMonitorFrame[] demoFrames;
	private javax.swing.JList ivjJListLabJacks = null;
	private javax.swing.JLabel ivjJLabelInstructions = null;
	private javax.swing.JScrollPane ivjJScrollPaneLabJacks = null;

	class IvjEventHandler implements java.awt.event.MouseListener {
		public void mouseClicked(java.awt.event.MouseEvent e) {
			if (e.getSource() == LabJackSelectionFrame.this.getJListLabJacks())
				connEtoC2(e);
		};
		public void mouseEntered(java.awt.event.MouseEvent e) {
		};
		public void mouseExited(java.awt.event.MouseEvent e) {
		};
		public void mousePressed(java.awt.event.MouseEvent e) {
		};
		public void mouseReleased(java.awt.event.MouseEvent e) {
		};
	};
	/**
	 * LabJackSelectionFrame constructor comment.
	 */
	public LabJackSelectionFrame() {
		super();
		initialize();
	}
	/**
	 * LabJackSelectionFrame constructor comment.
	 * @param title java.lang.String
	 */
	public LabJackSelectionFrame(String title) {
		super(title);
	}
	/**
	 * connEtoC2:  (listLabJacks.mouse.mouseClicked(java.awt.event.MouseEvent) --> LabJackSelectionFrame.listLabJacks_MouseClicked(Ljava.awt.event.MouseEvent;)V)
	 * @param arg1 java.awt.event.MouseEvent
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void connEtoC2(java.awt.event.MouseEvent arg1) {
		try {
			// user code begin {1}
			// user code end
			this.listLabJacks_MouseClicked(arg1);
			// user code begin {2}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {3}
			// user code end
			handleException(ivjExc);
		}
	}
	/**
	 * Return the JFrameContentPane property value.
	 * @return javax.swing.JPanel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JPanel getJFrameContentPane() {
		if (ivjJFrameContentPane == null) {
			try {
				ivjJFrameContentPane = new javax.swing.JPanel();
				ivjJFrameContentPane.setName("JFrameContentPane");
				ivjJFrameContentPane.setLayout(new java.awt.BorderLayout());
				getJFrameContentPane().add(getJLabelInstructions(), "North");
				getJFrameContentPane().add(getJScrollPaneLabJacks(), "Center");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJFrameContentPane;
	}
	/**
	 * Return the JLabel1 property value.
	 * @return javax.swing.JLabel
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JLabel getJLabelInstructions() {
		if (ivjJLabelInstructions == null) {
			try {
				ivjJLabelInstructions = new javax.swing.JLabel();
				ivjJLabelInstructions.setName("JLabelInstructions");
				ivjJLabelInstructions.setText("Double click a LabJack to monitor");
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJLabelInstructions;
	}
	/**
	 * Return the listLabJacks property value.
	 * @return javax.swing.JList
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JList getJListLabJacks() {
		if (ivjJListLabJacks == null) {
			try {
				ivjJListLabJacks = new javax.swing.JList();
				ivjJListLabJacks.setName("JListLabJacks");
				ivjJListLabJacks.setBounds(0, 0, 202, 20);
				ivjJListLabJacks.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
				// user code begin {1}
				try {
					LabJack[] availableLabJacks = (new LabJackFactory()).getLabJacks();
					this.demoFrames = new LabJackMonitorFrame[availableLabJacks.length];
					DefaultListModel model = new DefaultListModel();
					for (int i = 0; i < availableLabJacks.length; i++) {
						model.addElement(availableLabJacks[i]);
					}
					ivjJListLabJacks.setModel(model);
				} catch (LabJackException lje) {
					lje.printStackTrace(System.err);
					System.exit(0);
				}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJListLabJacks;
	}
	/**
	 * Return the JScrollPane1 property value.
	 * @return javax.swing.JScrollPane
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private javax.swing.JScrollPane getJScrollPaneLabJacks() {
		if (ivjJScrollPaneLabJacks == null) {
			try {
				ivjJScrollPaneLabJacks = new javax.swing.JScrollPane();
				ivjJScrollPaneLabJacks.setName("JScrollPaneLabJacks");
				getJScrollPaneLabJacks().setViewportView(getJListLabJacks());
				// user code begin {1}
				// user code end
			} catch (java.lang.Throwable ivjExc) {
				// user code begin {2}
				// user code end
				handleException(ivjExc);
			}
		}
		return ivjJScrollPaneLabJacks;
	}
	/**
	 * Called whenever the part throws an exception.
	 * @param exception java.lang.Throwable
	 */
	private void handleException(java.lang.Throwable exception) {

		/* Uncomment the following lines to print uncaught exceptions to stdout */
		System.out.println("--------- UNCAUGHT EXCEPTION ---------");
		exception.printStackTrace(System.out);
	}
	/**
	 * Initializes connections
	 * @exception java.lang.Exception The exception description.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initConnections() throws java.lang.Exception {
		// user code begin {1}
		// user code end
		getJListLabJacks().addMouseListener(ivjEventHandler);
	}
	/**
	 * Initialize the class.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initialize() {
		try {
			// user code begin {1}
			// user code end
			setName("LabJackSelectionFrame");
			setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
			setSize(424, 162);
			setTitle("LabJack Monitor");
			setContentPane(getJFrameContentPane());
			initConnections();
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
		// user code begin {2}
		// user code end
	}
	/**
	 * Comment
	 */
	public void listLabJacks_MouseClicked(java.awt.event.MouseEvent mouseEvent) {
		if (mouseEvent.getClickCount() > 1) {
			int i = this.getJListLabJacks().getSelectedIndex();
			if (this.demoFrames[i] != null) {
				demoFrames[i].show();
			} else {
				LabJackMonitorFrame aLabJackMonitorFrame = new LabJackMonitorFrame((LabJack) this.getJListLabJacks().getSelectedValue());
				aLabJackMonitorFrame.show();
				java.awt.Insets insets = aLabJackMonitorFrame.getInsets();
				aLabJackMonitorFrame.setSize(aLabJackMonitorFrame.getWidth() + insets.left + insets.right, aLabJackMonitorFrame.getHeight() + insets.top + insets.bottom);
				Point windowLocation = this.getLocationOnScreen();
				int offset = this.getHeight() - this.getContentPane().getHeight();
				windowLocation.translate((i + 1) * offset, (i + 1) * offset);
				aLabJackMonitorFrame.setLocation(windowLocation);
				aLabJackMonitorFrame.setVisible(true);
				this.demoFrames[i] = aLabJackMonitorFrame;
			}
		}
	}
	/**
	 * main entrypoint - starts the part when it is run as an application
	 * @param args java.lang.String[]
	 */
	public static void main(java.lang.String[] args) {
		try {
			LabJackSelectionFrame aLabJackSelectionFrame;
			aLabJackSelectionFrame = new LabJackSelectionFrame();
			aLabJackSelectionFrame.addWindowListener(new java.awt.event.WindowAdapter() {
				public void windowClosing(java.awt.event.WindowEvent e) {
					System.exit(0);
				};
			});
			aLabJackSelectionFrame.show();
			java.awt.Insets insets = aLabJackSelectionFrame.getInsets();
			aLabJackSelectionFrame.setSize(aLabJackSelectionFrame.getWidth() + insets.left + insets.right, aLabJackSelectionFrame.getHeight() + insets.top + insets.bottom);
			aLabJackSelectionFrame.setVisible(true);
		} catch (Throwable exception) {
			System.err.println("Exception occurred in main() of javax.swing.JFrame");
			exception.printStackTrace(System.out);
		}
	}
}
