package com.teravation.labjack;
/**
 * This file is part of LabJackJava.  Copyright 2003-2004, Teravation.  All rights reserved. 
 * 
 * LabJackJava is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * LabJackJava is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with LabJackJava;
 * if not, write to:
 *    Free Software Foundation, Inc.
 *    59 Temple Place, Suite 330
 *    Boston, MA  02111-1307  USA
 * 
 * In addition, as a special exception, Teravation gives permission to link the code of this program with
 * the LabJack C driver (or with modified versions of the LabJack C driver that use the same license),
 * and distribute linked combinations including the two.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the LabJack C driver.  If you modify this file, you may 
 * extend this exception to your version of the file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 * 
 */

/**
 * This class handles the creation of platform-specific instances of the {@link LabJack LabJack} interface.
 *
 * <p />Copyright &copy; 2003-2004 <a href="http://www.teravation.com">Teravation</a>. All rights reserved.
 * 
 * @created (12/30/2002 2:52:17 PM)
 * @version 4.0
 * @author Chris Reigrut 
 */
public class LabJackFactory {
	static private LabJack[] labjacks;
	
	/**
	 * LabJackFactory constructor (empty)
	 */
	public LabJackFactory() {
		super();
	}
	
	/**
	 * Returns one instance of LabJack for each physical device connected to the system
	 * 
	 * @created (12/30/2002 2:54:58 PM)
	 * 
	 * @param serialNumber int
	 * @return com.teravation.labjack.LabJack the LabJack object with the requested serial number, or null if not found
	 * @exception com.teravation.labjack.LabJackException on any underlying DLL error.
	 */
	public LabJack getLabJack(int serialNumber) throws LabJackException {
		LabJack labjack = null;
		LabJack[] labjacks = getLabJacks();
		for (int i=0; i < labjacks.length; i++) {
			if (labjacks[i].getSerialNumber() == serialNumber) {
				labjack = labjacks[i];
				break;
			}
		}

		return labjack;
	}

	/**
	 * Returns one instance of LabJack for each physical device connected to the system
	 * 
	 * @created (12/30/2002 2:54:58 PM)
	 * 
	 * @return com.teravation.labjack.LabJack[] the array of LabJack objects
	 * @exception com.teravation.labjack.LabJackException on any underlying DLL error.
	 */
	public LabJack[] getLabJacks() throws LabJackException {
		return getLabJacks(false);
	}
	
	/**
	 * Returns one instance of LabJack for each physical device connected to the system
	 * 
	 * @created (12/30/2002 2:54:58 PM)
	 * 
	 * @param find boolean
	 * @return com.teravation.labjack.LabJack[] the array of LabJack objects
	 * @exception com.teravation.labjack.LabJackException on any underlying DLL error.
	 */
	public LabJack[] getLabJacks(boolean find) throws LabJackException {
		if (find || labjacks == null) {
			String osName = System.getProperty("os.name");
			if (osName.startsWith("Windows") || osName.equals("Linux") || osName.equals("Mac OS X")) {
				labjacks = LabJackDriver.getAll();
			} else {
				System.out.println(osName);
				throw new LabJackException(-1);
			}
		}
	
		return labjacks;
	}
	
	/**
	 * Returns the version number of the underlying driver
	 * 
	 * @created (12/30/2002 2:54:58 PM)
	 * 
	 * @return float the version number of the underlying driver
	 * @exception com.teravation.labjack.LabJackException on any underlying DLL error.
	 */
	public float getDriverVersion() throws LabJackException {
		return LabJackDriver.getDriverVersion();
	}
}
