// TestLabJackDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TestLabJack.h"
#include "TestLabJackDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//extern "C" _stdcall(dllimport)float GetDriverVersion(void);

//extern "C" _stdcall float GetDriverVersion(void);

//extern "C" _stdcall float GetFirmwareVersion(long *idnum);
//extern "C" _stdcall long LocalID(long *idnum, long locallD);
//extern "C" _stdcall long Reset(long *idnum);
//extern "C" _stdcall long EAnalogIn(long *idnum, long demo, long channel, long gain, long *overVoltage, float *voltage);

//extern "C" _stdcall long AOUpdate(long *idnum, long demo, long trisD, long trisIO, long *stateD, long *stateIO, long updateDigital, long resetCounter, unsigned long *count, float analogOut0, float analogOut1);

#include "c:\Program Files\LabJackU12Legacy\drivers\ljackuw.h"


/////////////////////////////////////////////////////////////////////////////
// CTestLabJackDlg dialog

CTestLabJackDlg::CTestLabJackDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestLabJackDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestLabJackDlg)
	m_Version = 0.0f;
	m_Firmware = 0.0f;
	m_LocalID = 0;
	m_Voltage = 0.0f;
	m_VoltageRead = 0.0f;
	m_Temp = 0.0f;
	m_RH = 0.0f;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestLabJackDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestLabJackDlg)
	DDX_Text(pDX, IDC_EVersion, m_Version);
	DDX_Text(pDX, IDC_EFirmware, m_Firmware);
	DDX_Text(pDX, IDC_Eid, m_LocalID);
	DDX_Text(pDX, IDC_EVoltage, m_Voltage);
	DDX_Text(pDX, IDC_EVolRead, m_VoltageRead);
	DDX_Text(pDX, IDC_ETemp, m_Temp);
	DDX_Text(pDX, IDC_ERH, m_RH);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestLabJackDlg, CDialog)
	//{{AFX_MSG_MAP(CTestLabJackDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton7)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestLabJackDlg message handlers

BOOL CTestLabJackDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	long oldID=-1;
 	
	GetFirmwareVersion(&oldID);
	m_LocalID=oldID;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestLabJackDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestLabJackDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestLabJackDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	m_Version=999.9;
	m_Version=GetDriverVersion();
	long input=-1;
	m_Firmware=999.0;
	m_Firmware=GetFirmwareVersion(&input);
	if (m_Firmware==0.0) MessageBox("kl");
	
	UpdateData(FALSE);

}

void CTestLabJackDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	long input;
 	
//	m_Firmware=GetFirmwareVersion(&input);
//	m_LocalID=input;
//	UpdateData(FALSE);
	
	UpdateData(TRUE);

	input=m_LocalID;

	LocalID(&oldID,input);


	Reset(&oldID);
	
}

void CTestLabJackDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
//long *overVoltage;
long  overVoltage=0;
//float *voltage;
float voltage=0.;

long check;
//long inputt=-1;
char sentence[40];


check=EAnalogIn(&oldID, 0, 0, 0, &overVoltage, & voltage);
//sprintf(sentence,"check=%d ",check);
//MessageBox(sentence);
m_Voltage=voltage;

UpdateData(FALSE);
	
}

void CTestLabJackDlg::OnButton4() 
{
	
char sentence[40];
	// TODO: Add your control notification handler code here

long Darray[16];
long IOarray[4];

unsigned long count=333;
long tempe=99;
long tempid=-1;

IOarray[0]=1;
IOarray[1]=0;
IOarray[2]=1;
IOarray[3]=0;

for (int index=0;index<17; index++)
{Darray[index]=0;}


tempe=EDigitalOut(&tempid,0,0,1,0);
sprintf(sentence,"tempe=%d tempid =%d",tempe,tempid);
MessageBox(sentence);


tempid=-1;
tempe=EAnalogOut(&tempid,0,1,2);
sprintf(sentence,"tempe=%d count=%d tempid=%d",tempe,count,tempid);
MessageBox(sentence);
	

tempe=AOUpdate(&tempid,0,0,1,Darray,IOarray,1,0,&count,3.0f,5.0f);

sprintf(sentence,"tempe=%d count=%d tempid=%d",tempe,count,tempid);
MessageBox(sentence);
	
}

void CTestLabJackDlg::OnButton5() 
{
	// TODO: Add your control notification handler code here

 
long check;
char sentence[40];


check=EAnalogOut(&oldID, 0, 3.0,5.0);
sprintf(sentence,"check=%d ",check);
MessageBox(sentence);
	UpdateData(FALSE);
	
}

void CTestLabJackDlg::OnButton6() 
{
	// TODO: Add your control notification handler code here
	long check;
	long  overVoltage=0;
float voltage=0.;

char sentence[40];


check=EAnalogOut(&oldID, 0, 4.0,5.0);
//sprintf(sentence,"check=%d ",check);
//MessageBox(sentence);

check=EAnalogIn(&oldID, 0, 0, 0, &overVoltage, & voltage);
//sprintf(sentence,"check=%d ",check);
//MessageBox(sentence);
m_VoltageRead=voltage;

	UpdateData(FALSE);
	
}

void CTestLabJackDlg::OnButton7() 
{
	// TODO: Add your control notification handler code here
	float TempC=0.0;
	float TempF=0.0;
	float RH=0.0;
	long check;
	char sentence[40];

	check=SHT1X(&oldID,0,0,0,0,&TempC,&TempF,&RH);
	m_Temp=TempC;
	m_RH=RH;
//	sprintf(sentence,"check=%d ",check);
//MessageBox(sentence);

	UpdateData(FALSE);
	
}
