import u3
import time

print "Start"

myU3 = u3.U3()

'''
The eTape sensor (PN-6573P-12) is a solid state, continuous fluid level
sensor for measuring levels in water, non-corrosive water based liquids and
dry fluids (powders).

The eTape sensor has a resistance Gradient of 40 Ohm/in +-20%
'''

def convert_Inches(voltage):
    slope = -0.060 # based on calibration in water
    intercept = 1.121 # based on calibration in water
    inches = (voltage - intercept) / slope # Linear equation
    return inches

while True:
    
    '''Connected to FIO4 in a simple voltage divider circuit'''
    Volts = myU3.getAIN(4) # FIO4 Voltage reading
    Depth = convert_Inches(Volts)
    time.sleep(1)
    print Depth

print "Done"
