import u3
import time

print "Start"

myU3 = u3.U3() 

'''
The default shipped AddressByte of the SRF02 is 0xE0 *
Because this address would be larger than 1 byte if it were shifted 1 bit,
it must already include bit 0 as the read/write bit.
'''

UnShiftedAddress = 0x70 # Shifted is 0xE0

while True:
    '''
    List of commands to send in the i2c packet 
    command register (0x00) *
    result in inches (0x50), in cm (0x51), in micro-seconds (0x52) *
    '''
    I2cCommand = [0x00, 0x50]
    # Find the command format on i2c page of the U3 User's guide
    myU3.i2c(UnShiftedAddress, I2cCommand, SDAPinNum = 1, SCLPinNum = 0, NumI2CBytesToReceive = 0)

    time.sleep(.1) # wait for send/receive ultrasonic pulse

    I2cCommand = [] # No commands to send to register
    result = myU3.i2c(UnShiftedAddress, I2cCommand, SDAPinNum = 1, SCLPinNum = 0, NumI2CBytesToReceive = 5)
    print result ["I2CBytes"][2]

print "Done"

'''
*Note: Described in SRF02 documentation
http://www.robot-electronics.co.uk/htm/srf02techI2C.htm
'''
