/**
 * Name: auto_reconnect_test.c
 * Desc: Tests the LJM auto reconnect functionality.
**/

// For printf
#include <stdio.h>

// For the LabJackM Library
#include "LabJackM.h"

// For LabJackM helper functions
#include "../LJM_Utilities.h"

void ReconnectCallback(int handle)
{
	printf("Reconnected handle: %d\n", handle);
}

int main()
{
	int err, handle;
	int iteration = 0;
	int DeviceType, ConnectionType, SerialNumber, IPAddress, Port, MaxBytesPerMB;
	double value = 0;

	const char * NAME = {"SERIAL_NUMBER"};

	GetAndPrintConfigValue(LJM_LIBRARY_VERSION);

	EnableLoggingLevel(LJM_TRACE);

	// Set the timeouts shorter for testing convenience
	SetConfigValue(LJM_OPEN_TCP_DEVICE_TIMEOUT_MS, 500);
	SetConfigValue(LJM_SEND_RECEIVE_TIMEOUT_MS, 500);

	handle = OpenSOrDie("LJM_dtT7", "LJM_ctANY", "");

	err = LJM_RegisterDeviceReconnectCallback(handle, &ReconnectCallback);
	ErrorCheck(err, "LJM_RegisterDeviceReconnectCallback");

	printf("Press control + c to exit.\n");
	while (1) {
		printf("\n");
		printf("iteration: %d\n", iteration++);

		err = LJM_eReadName(handle, NAME, &value);
		PrintErrorIfError(err, "LJM_eReadName");
		if (err == LJME_NOERROR) {
			printf("%s: %.0f\n", NAME, value);

			err = LJM_GetHandleInfo(handle, &DeviceType, &ConnectionType,
				&SerialNumber, &IPAddress, &Port, &MaxBytesPerMB);
			PrintErrorIfError(err, "LJM_GetHandleInfo");
			if (err == LJME_NOERROR) {
				PrintDeviceInfo(DeviceType, ConnectionType, SerialNumber, IPAddress,
					Port, MaxBytesPerMB);
			}
		}

		printf("unplug, replug, wait\n");
		WaitForUser();
	}

	err = LJM_Close(handle);
	ErrorCheck(err, "LJM_Close");

	WaitForUserIfWindows();

	return LJME_NOERROR;
}
