Attribute VB_Name = "LabJackUD_VB"
'
' The UD library function calls for VB6/VBA. Requires LabJackUD.dll (UD library).
'
' The following UD library functions are excluded:
'   - String version (S/SS) of functions
'   - eGet Array version of functions. Use ByRef and Ptr versions which have the same functionality.
'   - eModbus
'
Global Const LabJackUD_VB_Version = 3.49


Declare PtrSafe Sub CloseAll Lib "labjackud.dll" Alias "Close" ()
'Renamed Close to CloseAll due to a name conflict, and the function closes all handles.

Declare PtrSafe Function ListAll Lib "labjackud.dll" (ByVal DeviceType As Long, ByVal ConnectionType As Long, ByRef NumFound As Long, ByRef SerialNumbers As Any, ByRef pIDs As Any, ByRef Addresses As Any) As Long

Declare PtrSafe Function OpenLabJack Lib "labjackud.dll" (ByVal DeviceType As Long, ByVal ConnectionType As Long, ByVal pAddress As String, ByVal FirstFound As Long, ByRef pHandle As Long) As Long

Declare PtrSafe Function AddRequest Lib "labjackud.dll" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByVal Value As Double, ByVal x1 As Long, ByVal UserData As Double) As Long
Declare PtrSafe Function AddRequest_ByRef Lib "labjackud.dll" Alias "AddRequestPtr" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByVal Value As Double, ByRef x1 As Any, ByVal UserData As Double) As Long
'AddRequest_ByRef is a special version for IOTypes LJ_ioGET_STREAM_DATA,
'LJ_ioRAW_OUT, and LJ_ioRAW_IN.  To allow array passing, x1 is
'passed by reference rather than by value.  Note that the arrays
'are handled by passing the address of the first element.  This
'probably will not work for arrays greater than 64 kB in size.
Declare PtrSafe Function AddRequestPtr Lib "labjackud.dll" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByVal Value As Double, ByRef x1 As Any, ByVal UserData As Double) As Long

Declare PtrSafe Function Go Lib "labjackud.dll" () As Long
Declare PtrSafe Function GoOne Lib "labjackud.dll" (ByVal Handle As Long) As Long

'eGet can actually put or get values, while ePut can only put.
Declare PtrSafe Function eGet Lib "labjackud.dll" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByRef Value As Double, ByVal x1 As Long) As Long
Declare PtrSafe Function eGet_ByRef Lib "labjackud.dll" Alias "eGetPtr" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByRef Value As Double, ByRef x1 As Any) As Long
'eGet_ByRef is a special version for IOTypes LJ_ioGET_STREAM_DATA,
'LJ_ioRAW_OUT, and LJ_ioRAW_IN.  To allow array passing, x1 is
'passed by reference rather than by value.  Note that the arrays
'are handled by passing the address of the first element.  This
'probably will not work for arrays greater than 64 kB in size.
Declare PtrSafe Function eGetPtr Lib "labjackud.dll" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByRef Value As Double, ByRef x1 As Any) As Long
Declare PtrSafe Function ePut Lib "labjackud.dll" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByVal Value As Double, ByVal x1 As Long) As Long

Declare PtrSafe Function GetResult Lib "labjackud.dll" (ByVal Handle As Long, ByVal IOType As Long, ByVal Channel As Long, ByRef Value As Double) As Long

Declare PtrSafe Function GetFirstResult Lib "labjackud.dll" (ByVal Handle As Long, ByRef IOType As Long, ByRef Channel As Long, ByRef Value As Double, ByRef x1 As Long, ByRef UserData As Double) As Long
Declare PtrSafe Function GetNextResult Lib "labjackud.dll" (ByVal Handle As Long, ByRef IOType As Long, ByRef Channel As Long, ByRef Value As Double, ByRef x1 As Long, ByRef UserData As Double) As Long

Declare PtrSafe Function eAIN Lib "labjackud.dll" (ByVal Handle As Long, ByVal ChannelP As Long, ByVal ChannelN As Long, ByRef Voltage As Double, ByVal Range As Long, ByVal Resolution As Long, ByVal Settling As Long, ByVal Binary As Long, ByVal Reserved1 As Long, ByVal Reserved2 As Long) As Long
Declare PtrSafe Function eDAC Lib "labjackud.dll" (ByVal Handle As Long, ByVal Channel As Long, ByVal Voltage As Double, ByVal Binary As Long, ByVal Reserved1 As Long, ByVal Reserved2 As Long) As Long
Declare PtrSafe Function eDI Lib "labjackud.dll" (ByVal Handle As Long, ByVal Channel As Long, ByRef State As Long) As Long
Declare PtrSafe Function eDO Lib "labjackud.dll" (ByVal Handle As Long, ByVal Channel As Long, ByVal State As Long) As Long
Declare PtrSafe Function eAddGoGet Lib "labjackud.dll" (ByVal Handle As Long, ByVal NumRequests As Long, ByRef aIOTypes As Any, ByRef aChannels As Any, ByRef aValues As Any, ByRef ax1s As Any, ByRef aRequestErrors As Any, ByRef GoError As Long, ByRef aResultErrors As Any) As Long
Declare PtrSafe Function eTCConfig Lib "labjackud.dll" (ByVal Handle As Long, ByRef aEnableTimers As Any, ByRef aEnableCounters As Any, ByVal TCPinOffset As Long, ByVal TimerClockBaseIndex As Long, ByVal TimerClockDivisor As Long, ByRef aTimerModes As Any, ByRef aTimerValues As Any, ByVal Reserved1 As Long, ByVal Reserved2 As Long) As Long
Declare PtrSafe Function eTCValues Lib "labjackud.dll" (ByVal Handle As Long, ByRef aReadTimers As Any, ByRef aUpdateResetTimers As Any, ByRef aReadCounters As Any, ByRef aResetCounters As Any, ByRef aTimerValues As Any, ByRef aCounterValues As Any, ByVal Reserved1 As Long, ByVal Reserved2 As Long) As Long

Declare PtrSafe Function ResetLabJack Lib "labjackud.dll" (ByVal Handle As Long) As Long

Declare PtrSafe Function GetNextError Lib "labjackud.dll" (ByVal Handle As Long, ByRef pIOType As Long, ByRef pChannel As Long) As Long

Declare PtrSafe Function GetStreamError Lib "labjackud.dll" (ByVal Handle As Long) As Long

Declare PtrSafe Function DoubleToStringAddress Lib "labjackud.dll" (ByVal Number As Double, ByVal pString As String, ByVal HexDot As Long) As Long
'The string must be initialized to 16 bytes.

Declare PtrSafe Function StringToDoubleAddress Lib "labjackud.dll" (ByVal pString As String, ByRef Number As Double, ByVal HexDot As Long) As Long

Declare PtrSafe Function StringToConstant Lib "labjackud.dll" (ByVal pString As String) As Long

Declare PtrSafe Sub ErrorToString Lib "labjackud.dll" (ByVal ErrorCode As Long, ByVal pErrorString As String)
'The string must be initialized to 256 bytes.
'Note that Strings are passed ByVal since they are inherently
'pointers.  Also, functions with no return value, are called
'a "Sub" in VB, rather than a "Function", and when you call
'a "Sub" you don't put parentheses around the parameters.

Declare PtrSafe Function GetDriverVersion Lib "labjackud.dll" () As Double

Declare PtrSafe Function GetThreadID Lib "labjackud.dll" () As Long

Declare PtrSafe Function TCVoltsToTemp Lib "labjackud.dll" (ByVal TCType As Long, ByVal TCVolts As Double, ByVal CJTempK As Double, ByRef pTCTempK As Double) As Long

'device types
Global Const LJ_dtUE9 = 9
Global Const LJ_dtU3 = 3
Global Const LJ_dtU6 = 6

'connection types
Global Const LJ_ctUSB = 1
Global Const LJ_ctETHERNET = 2
Global Const LJ_ctETHERNET_MB = 3
Global Const LJ_ctETHERNET_DATA_ONLY = 4

Global Const LJ_ctUSB_RAW = 101
Global Const LJ_ctETHERNET_RAW = 102

'io types
Global Const LJ_ioGET_AIN = 10
Global Const LJ_ioGET_AIN_DIFF = 15
Global Const LJ_ioGET_AIN_ADVANCED = 16

Global Const LJ_ioPUT_AIN_RANGE = 2000
Global Const LJ_ioGET_AIN_RANGE = 2001

Global Const LJ_ioPUT_ANALOG_ENABLE_BIT = 2013
Global Const LJ_ioGET_ANALOG_ENABLE_BIT = 2014
Global Const LJ_ioPUT_ANALOG_ENABLE_PORT = 2015
Global Const LJ_ioGET_ANALOG_ENABLE_PORT = 2016

Global Const LJ_ioPUT_DAC = 20
Global Const LJ_ioPUT_DAC_ENABLE = 2002
Global Const LJ_ioGET_DAC_ENABLE = 2003

Global Const LJ_ioGET_DIGITAL_BIT = 30
Global Const LJ_ioGET_DIGITAL_BIT_DIR = 31
Global Const LJ_ioGET_DIGITAL_BIT_STATE = 32

Global Const LJ_ioGET_DIGITAL_PORT = 35
Global Const LJ_ioGET_DIGITAL_PORT_DIR = 36
Global Const LJ_ioGET_DIGITAL_PORT_STATE = 37

Global Const LJ_ioPUT_DIGITAL_BIT = 40
Global Const LJ_ioPUT_DIGITAL_PORT = 45

Global Const LJ_ioPUT_WAIT = 70

Global Const LJ_ioGET_COUNTER = 50

Global Const LJ_ioPUT_COUNTER_ENABLE = 2008
Global Const LJ_ioGET_COUNTER_ENABLE = 2009

Global Const LJ_ioPUT_COUNTER_RESET = 2012

Global Const LJ_ioGET_TIMER = 60

Global Const LJ_ioPUT_TIMER_VALUE = 2006
Global Const LJ_ioPUT_TIMER_MODE = 2004
Global Const LJ_ioGET_TIMER_MODE = 2005

Global Const LJ_ioSHT_GET_READING = 500

Global Const LJ_ioSPI_COMMUNICATION = 503

Global Const LJ_ioI2C_COMMUNICATION = 504
Global Const LJ_ioASYNCH_COMMUNICATION = 505
Global Const LJ_ioTDAC_COMMUNICATION = 506

Global Const LJ_ioPIN_CONFIGURATION_RESET = 2017

Global Const LJ_ioRAW_OUT = 100
Global Const LJ_ioRAW_IN = 101

Global Const LJ_ioSET_DEFAULTS = 103

Global Const LJ_ioADD_STREAM_CHANNEL = 200
Global Const LJ_ioADD_STREAM_CHANNEL_DIFF = 206
Global Const LJ_ioCLEAR_STREAM_CHANNELS = 201
Global Const LJ_ioSTART_STREAM = 202
Global Const LJ_ioSTOP_STREAM = 203
Global Const LJ_ioGET_STREAM_DATA = 204

Global Const LJ_ioSET_STREAM_CALLBACK = 205
Global Const LJ_ioSET_STREAM_CALLBACK_PTR = 260

Global Const LJ_ioSET_EVENT_CALLBACK = 400

Global Const LJ_ioBUZZER = 300

Global Const LJ_ecDISCONNECT = 1
Global Const LJ_ecRECONNECT = 2
Global Const LJ_ecSTREAMERROR = 4

'config iotypes
Global Const LJ_ioPUT_CONFIG = 1000
Global Const LJ_ioGET_CONFIG = 1001

'channel numbers used for CONFIG types
'UE9 + U3 + U6
Global Const LJ_chLOCALID = 0
Global Const LJ_chHARDWARE_VERSION = 10
Global Const LJ_chSERIAL_NUMBER = 12
Global Const LJ_chFIRMWARE_VERSION = 11
Global Const LJ_chBOOTLOADER_VERSION = 15
Global Const LJ_chPRODUCTID = 8

'UE9 specific
Global Const LJ_chCOMM_POWER_LEVEL = 1
Global Const LJ_chIP_ADDRESS = 2
Global Const LJ_chGATEWAY = 3
Global Const LJ_chSUBNET = 4
Global Const LJ_chPORTA = 5
Global Const LJ_chPORTB = 6
Global Const LJ_chDHCP = 7
Global Const LJ_chMACADDRESS = 9
Global Const LJ_chCOMM_FIRMWARE_VERSION = 11
Global Const LJ_chCONTROL_POWER_LEVEL = 13
Global Const LJ_chCONTROL_FIRMWARE_VERSION = 14
Global Const LJ_chCONTROL_BOOTLOADER_VERSION = 15
Global Const LJ_chCONTROL_RESET_SOURCE = 16
Global Const LJ_chUE9_PRO = 19

'U3 and U6 specific
Global Const LJ_chLED_STATE = 17
Global Const LJ_chSDA_SCL = 18

'U3 specific
Global Const LJ_chU3HV = 22

'U6 specific
Global Const LJ_chU6_PRO = 23

Global Const LJ_chCOMMUNICATION_TIMEOUT = 20
Global Const LJ_chSTREAM_COMMUNICATION_TIMEOUT = 21

Global Const LJ_chCAL_CONSTANTS = 400
Global Const LJ_chUSER_MEM = 402
Global Const LJ_chUSB_STRINGS = 404

'timer/counter related
Global Const LJ_chNUMBER_TIMERS_ENABLED = 1000
Global Const LJ_chTIMER_CLOCK_BASE = 1001
Global Const LJ_chTIMER_CLOCK_DIVISOR = 1002
Global Const LJ_chTIMER_COUNTER_PIN_OFFSET = 1003

'AIN related
Global Const LJ_chAIN_RESOLUTION = 2000
Global Const LJ_chAIN_SETTLING_TIME = 2001
Global Const LJ_chAIN_BINARY = 2002

'DAC related
Global Const LJ_chDAC_BINARY = 3000

'SHT related
Global Const LJ_chSHT_TEMP = 5000
Global Const LJ_chSHT_RH = 5001
Global Const LJ_chSHT_DATA_CHANNEL = 5002
Global Const LJ_chSHT_CLOCK_CHANNEL = 5003

'SPI related
Global Const LJ_chSPI_AUTO_CS = 5100
Global Const LJ_chSPI_DISABLE_DIR_CONFIG = 5101
Global Const LJ_chSPI_MODE = 5102
Global Const LJ_chSPI_CLOCK_FACTOR = 5103
Global Const LJ_chSPI_MOSI_PINNUM = 5104
Global Const LJ_chSPI_MISO_PINNUM = 5105
Global Const LJ_chSPI_CLK_PINNUM = 5106
Global Const LJ_chSPI_CS_PINNUM = 5107

'I2C related
Global Const LJ_chI2C_ADDRESS_BYTE = 5108
Global Const LJ_chI2C_SCL_PIN_NUM = 5109
Global Const LJ_chI2C_SDA_PIN_NUM = 5110
Global Const LJ_chI2C_OPTIONS = 5111
Global Const LJ_chI2C_SPEED_ADJUST = 5112

'Used with LJ_ioI2C_COMMUNICATION
Global Const LJ_chI2C_READ = 5113
Global Const LJ_chI2C_WRITE = 5114
Global Const LJ_chI2C_GET_ACKS = 5115
Global Const LJ_chI2C_WRITE_READ = 5130

'Asynch related
'Used with LJ_ioASYNCH_COMMUNICATION
Global Const LJ_chASYNCH_RX = 5117
Global Const LJ_chASYNCH_TX = 5118
Global Const LJ_chASYNCH_FLUSH = 5128
Global Const LJ_chASYNCH_ENABLE = 5129

'Used with LJ_ioPUT_CONFIG and LJ_ioGET_CONFIG
Global Const LJ_chASYNCH_BAUDFACTOR = 5127

'LJTick-DAC related
'Used with put/get config.
Global Const LJ_chTDAC_SCL_PIN_NUM = 5119

'Used with LJ_ioTDAC_COMMUNICATION
Global Const LJ_chTDAC_SERIAL_NUMBER = 5120
Global Const LJ_chTDAC_READ_USER_MEM = 5121
Global Const LJ_chTDAC_WRITE_USER_MEM = 5122
Global Const LJ_chTDAC_READ_CAL_CONSTANTS = 5123
Global Const LJ_chTDAC_WRITE_CAL_CONSTANTS = 5124
Global Const LJ_chTDAC_UPDATE_DACA = 5125
Global Const LJ_chTDAC_UPDATE_DACB = 5126

'Stream related.  Note: Putting to any of these values will stop any running streams.
Global Const LJ_chSTREAM_SCAN_FREQUENCY = 4000
Global Const LJ_chSTREAM_BUFFER_SIZE = 4001
Global Const LJ_chSTREAM_CLOCK_OUTPUT = 4002
Global Const LJ_chSTREAM_EXTERNAL_TRIGGER = 4003
Global Const LJ_chSTREAM_WAIT_MODE = 4004
Global Const LJ_chSTREAM_DISABLE_AUTORECOVERY = 4005
Global Const LJ_chSTREAM_SAMPLES_PER_PACKET = 4108
Global Const LJ_chSTREAM_READS_PER_SECOND = 4109
Global Const LJ_chAIN_STREAM_SETTLING_TIME = 4110

'readonly stream related
Global Const LJ_chSTREAM_BACKLOG_COMM = 4105
Global Const LJ_chSTREAM_BACKLOG_CONTROL = 4106
Global Const LJ_chSTREAM_BACKLOG_UD = 4107

'Special channel #'s
Global Const LJ_chALL_CHANNELS = -1
Global Const LJ_INVALID_CONSTANT = -999

'Thermocouple Constants
Global Const LJ_ttB = 6001
Global Const LJ_ttE = 6002
Global Const LJ_ttJ = 6003
Global Const LJ_ttK = 6004
Global Const LJ_ttN = 6005
Global Const LJ_ttR = 6006
Global Const LJ_ttS = 6007
Global Const LJ_ttT = 6008

'Other constants:
'Ranges (not all are supported by all devices):
Global Const LJ_rgBIP20V = 1  ' -20V to +20V
Global Const LJ_rgBIP10V = 2  ' -10V to +10V
Global Const LJ_rgBIP5V = 3   ' -5V to +5V
Global Const LJ_rgBIP4V = 4   ' -4V to +4V
Global Const LJ_rgBIP2P5V = 5 ' -2.5V to +2.5V
Global Const LJ_rgBIP2V = 6   ' -2V to +2V
Global Const LJ_rgBIP1P25V = 7  ' -1.25V to +1.25V
Global Const LJ_rgBIP1V = 8   ' -1V to +1V
Global Const LJ_rgBIPP625V = 9  ' -0.625V to +0.625V
Global Const LJ_rgBIPP1V = 10  ' -0.1V to +0.1V
Global Const LJ_rgBIPP01V = 11  ' -0.01V to +0.01V

Global Const LJ_rgUNI20V = 101  ' 0V to +20V
Global Const LJ_rgUNI10V = 102  ' 0V to +10V
Global Const LJ_rgUNI5V = 103   ' 0V to +5V
Global Const LJ_rgUNI4V = 104   ' 0V to +4V
Global Const LJ_rgUNI2P5V = 105  ' 0V to +2.5V
Global Const LJ_rgUNI2V = 106    ' 0V to +2V
Global Const LJ_rgUNI1P25V = 107  ' 0V to +1.25V
Global Const LJ_rgUNI1V = 108   ' 0V to +1V
Global Const LJ_rgUNIP625V = 109  ' 0V to +0.625V
Global Const LJ_rgUNIP5V = 110  ' 0V to +0.500V
Global Const LJ_rgUNIP25V = 112  ' 0V to +0.25V
Global Const LJ_rgUNIP3125V = 111  ' 0V to +0.3125V
Global Const LJ_rgUNIP025V = 113  ' 0V to +0.025V
Global Const LJ_rgUNIP0025V = 114  ' 0V to +0.0025V

'timer modes
Global Const LJ_tmPWM16 = 0
Global Const LJ_tmPWM8 = 1
Global Const LJ_tmRISINGEDGES32 = 2
Global Const LJ_tmFALLINGEDGES32 = 3
Global Const LJ_tmDUTYCYCLE = 4
Global Const LJ_tmFIRMCOUNTER = 5
Global Const LJ_tmFIRMCOUNTERDEBOUNCE = 6
Global Const LJ_tmFREQOUT = 7
Global Const LJ_tmQUAD = 8
Global Const LJ_tmTIMERSTOP = 9
Global Const LJ_tmSYSTIMERLOW = 10
Global Const LJ_tmSYSTIMERHIGH = 11
Global Const LJ_tmRISINGEDGES16 = 12
Global Const LJ_tmFALLINGEDGES16 = 13
Global Const LJ_tmLINETOLINE = 14

'Timer clocks
Global Const LJ_tc750KHZ = 0
Global Const LJ_tcSYS = 1

Global Const LJ_tc2MHZ = 10
Global Const LJ_tc6MHZ = 11
Global Const LJ_tc24MHZ = 12
Global Const LJ_tc500KHZ_DIV = 13
Global Const LJ_tc2MHZ_DIV = 14
Global Const LJ_tc6MHZ_DIV = 15
Global Const LJ_tc24MHZ_DIV = 16

Global Const LJ_tc4MHZ = 20
Global Const LJ_tc12MHZ = 21
Global Const LJ_tc48MHZ = 22
Global Const LJ_tc1MHZ_DIV = 23
Global Const LJ_tc4MHZ_DIV = 24
Global Const LJ_tc12MHZ_DIV = 25
Global Const LJ_tc48MHZ_DIV = 26

'Stream wait modes
Global Const LJ_swNONE = 1
Global Const LJ_swALL_OR_NONE = 2
Global Const LJ_swPUMP = 11
Global Const LJ_swSLEEP = 12

'SWDT related
Global Const LJ_ioSWDT_CONFIG = 507
Global Const LJ_ioSWDT_STROKE = 508

Global Const LJ_chSWDT_ENABLE = 5200
Global Const LJ_chSWDT_DISABLE = 5201

'Used with LJ_io_PUT_CONFIG
Global Const LJ_chSWDT_RESET_DEVICE = 5202
Global Const LJ_chSWDT_RESET_COMM = 5203
Global Const LJ_chSWDT_RESET_CONTROL = 5204
Global Const LJ_chSWDT_UDPATE_DIOA = 5205
Global Const LJ_chSWDT_UPDATE_DIOB = 5206
Global Const LJ_chSWDT_DIOA_CHANNEL = 5207
Global Const LJ_chSWDT_DIOA_STATE = 5208
Global Const LJ_chSWDT_DIOB_CHANNEL = 5209
Global Const LJ_chSWDT_DIOB_STATE = 5210
Global Const LJ_chSWDT_UPDATE_DAC0 = 5211
Global Const LJ_chSWDT_UPDATE_DAC1 = 5212
Global Const LJ_chSWDT_DAC0 = 5213
Global Const LJ_chSWDT_DAC1 = 5214
Global Const LJ_chSWDT_DAC_ENABLE = 5215
Global Const LJ_chSWDT_STRICT_ENABLE = 5216
Global Const LJ_chSWDT_INITIAL_ROLL_TIME = 5217


'error codes:  These will always be in the range of -1000 to 3999 for labView compatibility (+6000)
Global Const LJE_NOERROR = 0
Global Const LJE_COMMAND_LIST_ERROR = 1
Global Const LJE_INVALID_CHANNEL_NUMBER = 2
Global Const LJE_INVALID_RAW_INOUT_PARAMETER = 3
Global Const LJE_UNABLE_TO_START_STREAM = 4
Global Const LJE_UNABLE_TO_STOP_STREAM = 5
Global Const LJE_NOTHING_TO_STREAM = 6
Global Const LJE_UNABLE_TO_CONFIG_STREAM = 7
Global Const LJE_BUFFER_OVERRUN = 8
Global Const LJE_STREAM_NOT_RUNNING = 9
Global Const LJE_INVALID_PARAMETER = 10
Global Const LJE_INVALID_STREAM_FREQUENCY = 11
Global Const LJE_INVALID_AIN_RANGE = 12
Global Const LJE_STREAM_CHECKSUM_ERROR = 13
Global Const LJE_STREAM_COMMAND_ERROR = 14
Global Const LJE_STREAM_ORDER_ERROR = 15
Global Const LJE_AD_PIN_CONFIGURATION_ERROR = 16
Global Const LJE_REQUEST_NOT_PROCESSED = 17

Global Const LJE_SCRATCH_ERROR = 19
Global Const LJE_DATA_BUFFER_OVERFLOW = 20
Global Const LJE_ADC0_BUFFER_OVERFLOW = 21
Global Const LJE_FUNCTION_INVALID = 22
Global Const LJE_SWDT_TIME_INVALID = 23
Global Const LJE_FLASH_ERROR = 24
Global Const LJE_STREAM_IS_ACTIVE = 25
Global Const LJE_STREAM_TABLE_INVALID = 26
Global Const LJE_STREAM_CONFIG_INVALID = 27
Global Const LJE_STREAM_BAD_TRIGGER_SOURCE = 28
Global Const LJE_STREAM_INVALID_TRIGGER = 30
Global Const LJE_STREAM_ADC0_BUFFER_OVERFLOW = 31

Global Const LJE_STREAM_SAMPLE_NUM_INVALID = 33
Global Const LJE_STREAM_BIPOLAR_GAIN_INVALID = 34
Global Const LJE_STREAM_SCAN_RATE_INVALID = 35
Global Const LJE_TIMER_INVALID_MODE = 36
Global Const LJE_TIMER_QUADRATURE_AB_ERROR = 37
Global Const LJE_TIMER_QUAD_PULSE_SEQUENCE = 38
Global Const LJE_TIMER_BAD_CLOCK_SOURCE = 39
Global Const LJE_TIMER_STREAM_ACTIVE = 40
Global Const LJE_TIMER_PWMSTOP_MODULE_ERROR = 41
Global Const LJE_TIMER_SEQUENCE_ERROR = 42
Global Const LJE_TIMER_SHARING_ERROR = 43
Global Const LJE_TIMER_LINE_SEQUENCE_ERROR = 44
Global Const LJE_EXT_OSC_NOT_STABLE = 45
Global Const LJE_INVALID_POWER_SETTING = 46
Global Const LJE_PLL_NOT_LOCKED = 47
Global Const LJE_INVALID_PIN = 48
Global Const LJE_IOTYPE_SYNCH_ERROR = 49
Global Const LJE_INVALID_OFFSET = 50
Global Const LJE_FEEDBACK_IOTYPE_NOT_VALID = 51

Global Const LJE_CANT_CONFIGURE_PIN_FOR_ANALOG = 67
Global Const LJE_CANT_CONFIGURE_PIN_FOR_DIGITAL = 68
Global Const LJE_TC_PIN_OFFSET_MUST_BE_4_TO_8 = 70
Global Const LJE_INVALID_DIFFERENTIAL_CHANNEL = 71
Global Const LJE_DSP_SIGNAL_OUT_OF_RANGE = 72

Global Const LJE_SHT_CRC = 52
Global Const LJE_SHT_MEASREADY = 53
Global Const LJE_SHT_ACK = 54
Global Const LJE_SHT_SERIAL_RESET = 55
Global Const LJE_SHT_COMMUNICATION = 56

Global Const LJE_AIN_WHILE_STREAMING = 57

Global Const LJE_STREAM_TIMEOUT = 58
Global Const LJE_STREAM_CONTROL_BUFFER_OVERFLOW = 59
Global Const LJE_STREAM_SCAN_OVERLAP = 60

Global Const LJE_FIRMWARE_VERSION_IOTYPE = 61
Global Const LJE_FIRMWARE_VERSION_CHANNEL = 62
Global Const LJE_FIRMWARE_VERSION_VALUE = 63
Global Const LJE_HARDWARE_VERSION_IOTYPE = 64
Global Const LJE_HARDWARE_VERSION_CHANNEL = 65
Global Const LJE_HARDWARE_VERSION_VALUE = 66

Global Const LJE_LJTDAC_ACK_ERROR = 69

Global Const LJE_STREAM_INVALID_CONNECTION = 73

Global Const LJE_MIN_GROUP_ERROR = 1000

Global Const LJE_UNKNOWN_ERROR = 1001
Global Const LJE_INVALID_DEVICE_TYPE = 1002
Global Const LJE_INVALID_HANDLE = 1003
Global Const LJE_DEVICE_NOT_OPEN = 1004
Global Const LJE_NO_DATA_AVAILABLE = 1005
Global Const LJE_NO_MORE_DATA_AVAILABLE = 1006
Global Const LJE_LABJACK_NOT_FOUND = 1007
Global Const LJE_COMM_FAILURE = 1008
Global Const LJE_CHECKSUM_ERROR = 1009
Global Const LJE_DEVICE_ALREADY_OPEN = 1010
Global Const LJE_COMM_TIMEOUT = 1011
Global Const LJE_USB_DRIVER_NOT_FOUND = 1012
Global Const LJE_INVALID_CONNECTION_TYPE = 1013
Global Const LJE_INVALID_MODE = 1014
Global Const LJE_DEVICE_NOT_CONNECTED = 1015

Global Const LJE_DISCONNECT = 2000
Global Const LJE_RECONNECT = 2001

Global Const LJE_MIN_USER_ERROR = 3000
Global Const LJE_MAX_USER_ERROR = 3999

'Warnings are negative
Global Const LJE_DEVICE_NOT_CALIBRATED = -1
Global Const LJE_UNABLE_TO_READ_CALDATA = -2


'Depreciated constants.  Do not use.
Global Const LJ_ioANALOG_INPUT = 10
Global Const LJ_ioANALOG_OUTPUT = 20
Global Const LJ_ioDIGITAL_BIT_IN = 30
Global Const LJ_ioDIGITAL_PORT_IN = 35
Global Const LJ_ioDIGITAL_BIT_OUT = 40
Global Const LJ_ioDIGITAL_PORT_OUT = 45
Global Const LJ_ioCOUNTER = 50
Global Const LJ_ioTIMER = 60
Global Const LJ_ioPUT_COUNTER_MODE = 2010
Global Const LJ_ioGET_COUNTER_MODE = 2011
Global Const LJ_ioGET_TIMER_VALUE = 2007
Global Const LJ_ioCYCLE_PORT = 102
Global Const LJ_chTIMER_CLOCK_CONFIG = 1001
Global Const LJ_ioPUT_CAL_CONSTANTS = 400
Global Const LJ_ioGET_CAL_CONSTANTS = 401
Global Const LJ_ioPUT_USER_MEM = 402
Global Const LJ_ioGET_USER_MEM = 403
Global Const LJ_ioPUT_USB_STRINGS = 404
Global Const LJ_ioGET_USB_STRINGS = 405
Global Const LJ_ioSHT_DATA_CHANNEL = 501
Global Const LJ_ioSHT_CLOCK_CHANNEL = 502
Global Const LJ_chI2C_ADDRESS = 5108
Global Const LJ_chASYNCH_CONFIG = 5116
Global Const LJ_rgUNIP500V = 110  ' 0V to +0.500V
Global Const LJ_ioENABLE_POS_PULLDOWN = 2018  ' U6
Global Const LJ_ioENABLE_NEG_PULLDOWN = 2019  ' U6
Global Const LJ_rgAUTO = 0
