#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
T7Pro_GoogleSheet.py

T7Pro-based output monitoring added to a GoogleSheet via Google's Python API
including a time stamp
Written in Python 3.7

Created on Mon Jun 1 14:59:00 2020

@author: Darby Bates
@contributor: LabJack Corporation
@maintainer: LabJack Corporation
@licenser: MIT
"""
from labjack import ljm
import time
import gspread
from oauth2client.service_account import ServiceAccountCredentials

SPREADSHEETNAME = 'LJ Test Sheet' #Edit spreadsheet name here

scope = ['https://spreadsheets.google.com/feeds', 'https://www.googleapis.com/auth/drive']
creds = ServiceAccountCredentials.from_json_keyfile_name('client_secret.json', scope)
client = gspread.authorize(creds)

sheet = client.open(SPREADSHEETNAME).sheet1

# Open first found LabJack
handle = ljm.openS("ANY", "ANY", "ANY")

#Channels to be output to sheet
Channel_1 = "AIN0"
Channel_2 = "AIN1"
Channel_3 = "AIN2"

# Call eReadName to read the flow rate via the LabJack
Output_1 = ljm.eReadName(handle, Channel_1)
Output_2 = ljm.eReadName(handle, Channel_2)
Output_3 = ljm.eReadName(handle, Channel_3)

# Time Stamp the data collected from python, gives approximate time stamp
ts = time.gmtime()
Time = time.strftime("%H:%M %Y-%m-%d", ts)

#Upload data as new 2nd row from top in spreadsheet
row = [Time, Output_1, Output_2, Output_3]
index = 2
sheet.insert_row(row,index)