{
  WriteDeviceNameString.dpr

  Demonstrates how to set the device name string on a LabJack.
}

program WriteDeviceNameString;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  writeString: PAnsiChar = 'LJTest'; { Max character length is LJM_MAX_NAME_SIZE. } 
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Set the LabJack's device name string. }
  error := LJM_eWriteNameString(handle, 'DEVICE_NAME_DEFAULT', writeString);
  //error := LJM_eWriteNameString(handle, 'DEVICE_NAME_DEFAULT', 'LJTest'); { Will work as well }
  ErrorHandler('LJM_eWriteNameString', error);
  
  Writeln('Set device name = ' + writeString);

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
