{
  ReadWiFiRSSI.dpr

  Demonstrates how to read the WiFI RSSI from a LabJack.
}

program ReadWiFiRSSI;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  handle: Integer;
  error: Integer = 0;
  value: Double = 0.0;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Read the WiFi RSSI. }
  error := LJM_eReadName(handle, 'WIFI_RSSI', value);
  ErrorHandler('LJM_eReadName', error);

  Writeln('WiFi RSSI = ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
