{
  eNames.dpr

  Demonstrates how to use the LJM_eNames function.
}

program eNames;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

const
  aNames: array[0..2] of PAnsiChar = ('DAC0', 'TEST_UINT16', 'TEST_UINT16');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 3;
  aWrites: array[0..2] of Integer = (LJM_WRITE, LJM_WRITE, LJM_READ);
  aNumValues: array[0..2] of Integer = (1, 1, 1);
  aValues: array[0..2] of Double = (2.5, 12345, 0);
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eNames to write/read multiple values to/from the LabJack. }
  { In this case we are setting DAC0 and TEST_UINT16 to 2.5 V and 12345, and }
  { reading TEST_UINT16. }
  error := LJM_eNames(handle, numFrames, @aNames, @aWrites, @aNumValues, @aValues, errorAddress);
  ErrorHandler('LJM_eNames', error, errorAddress);

  Writeln('LJM_eNames:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  Name = ' + aNames[i] + ' , write = ' + IntToStr(aWrites[i]) + ', value = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
