{
  eReadNames.dpr

  Demonstrates how to use the LJM_eReadNames function.
}

program eReadNames;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

const
  aNames: array[0..2] of PAnsiChar = ('SERIAL_NUMBER', 'PRODUCT_ID', 'FIRMWARE_VERSION');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 3;
  aValues: array[0..2] of Double = (0.0, 0.0, 0.0);
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eReadNames to read multiple values from the LabJack. }
  { In this case we are reading the serial number, product ID and firmware version. }
  error := LJM_eReadNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eReadNames', error, errorAddress);

  Writeln('LJM_eReadNames:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  Name = ' + aNames[i] + ' , read value = ' + FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
