{
  eWriteName.dpr

  Demonstrates how to use the LJM_eWriteName function.
}

program eWriteName;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

const
  name: PAnsiChar = 'DAC0';

var
  handle: Integer;
  error: Integer = 0;
  value: Double = 2.5;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eWriteName to write a value to the LabJack. }
  { In this case we are setting DAC0 to 2.5 V. }
  error := LJM_eWriteName(handle, name, value);
  ErrorHandler('LJM_eWriteName', error);

  Writeln('LJM_eWriteName:');
  Writeln('  Name = ' + name + ' , value = ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
