{
  DualAINLoop.dpr

  Demonstrates reading 2 analog inputs (AINs) in a loop from a LabJack.
}

program DualAINLoop;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  { Configuration frames }
  numFramesW: Integer = 6;
  { Configuration names }
  aNamesW: array[0..5] of PAnsiChar = (
        'AIN0_NEGATIVE_CH', 'AIN0_RANGE', 'AIN0_RESOLUTION_INDEX',
        'AIN1_NEGATIVE_CH', 'AIN1_RANGE', 'AIN1_RESOLUTION_INDEX');
  { Readings frames }
  numFramesR: Integer = 2;
  { Readings names }
  aNamesR: array[0..1] of PAnsiChar = ('AIN0', 'AIN1');
var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  aValuesW: array[0..5] of Double = (
        199, 10, 0,
        199, 10, 0 );
  { Readings values }
  aValuesR: array[0..1] of Double = ( 0, 0 );
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Configuring AIN0_NEGATIVE_CH to 199, AIN0_RANGE to 10, AIN0_RESOLUTION_INDEX
  { to 0, AIN1_NEGATIVE_CH to 199, AIN1_RANGE to 10, and AIN1_RESOLUTION_INDEX
  { to 0. }
  error := LJM_eWriteNames(handle, numFramesW, @aNamesW, @aValuesW, errorAddress);
  ErrorHandler('LJM_eWriteNames (Configuration)', error, errorAddress);

  Writeln('Configuration:');
  for i := 0 to numFramesW-1 do
  begin
    Writeln('  ' + aNamesW[i] + ' = ' + FloatToStr(aValuesW[i]));
  end;

  Writeln('');

  { Reading AIN0 and AIN1 in a loop with a 1 second delay. }
  Writeln('Starting read loop. Press Ctrl+C to exit the application.');
  Sleep(1000); { Extra delay to read the message. }
  while True do
  begin
    Sleep(1000);
    error := LJM_eReadNames(handle, numFramesR, @aNamesR, @aValuesR, errorAddress);
    ErrorHandler('LJM_eReadNames (Readings)', error, errorAddress);

    Writeln('');
    for i := 0 to numFramesR-1 do
    begin
      Writeln(aNamesR[i] + ' = ' + FormatFloat('0.00000', aValuesR[i]) + ' V');
    end;
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
