{
  ReadConfig.dpr

  Demonstrates how to read configuration settings on a LabJack.
}

program ReadConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 10;
  { Configuration names. }
  aNames: array[0..9] of PAnsiChar =
        ('PRODUCT_ID', 'HARDWARE_VERSION', 'FIRMWARE_VERSION',
         'BOOTLOADER_VERSION', 'WIFI_VERSION', 'SERIAL_NUMBER',
         'POWER_ETHERNET_DEFAULT', 'POWER_WIFI_DEFAULT', 'POWER_AIN_DEFAULT',
         'POWER_LED_DEFAULT');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values readings }
  aValues: array[0..9] of Double;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Reading LabJack's configurations }
  error := LJM_eReadNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eReadNames', error, errorAddress);

  Writeln('Read Configuration:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  ' + aNames[i] + ' , read value = ' + FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
