{
  ReadDeviceNameString.dpr

  Demonstrates how to read the device name string from a LabJack.
}

program ReadDeviceNameString;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  readString: Array[0..LJM_MAX_NAME_SIZE-1] of AnsiChar;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Reading LabJack's device name string. }
  error := LJM_eReadNameString(handle, 'DEVICE_NAME_DEFAULT', readString);
  ErrorHandler('LJM_eReadNameString', error);
  
  Writeln('Device name = ' + readString);

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
