{
  ReadEthernetConfig.dpr

  Demonstrates how to read the ethernet configuration settings from a LabJack.
}

program ReadEthernetConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  StrUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 8;
  { Configuration names }
  aNames: array[0..7] of PAnsiChar = (
      'ETHERNET_IP', 'ETHERNET_SUBNET', 'ETHERNET_GATEWAY',
      'ETHERNET_IP_DEFAULT', 'ETHERNET_SUBNET_DEFAULT', 'ETHERNET_GATEWAY_DEFAULT',
      'ETHERNET_DHCP_ENABLE', 'ETHERNET_DHCP_ENABLE_DEFAULT');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  aValues: array[0..7] of Double;
  ipStr: array[0..LJM_IPv4_STRING_SIZE-1] of AnsiChar;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Read ethernet configuration settings }
  error := LJM_eReadNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eReadNames', error, errorAddress);

  Writeln('Read Ethernet Configuration:');
  for i := 0 to numFrames-1 do
  begin
    if AnsiStartsStr('ETHERNET_DHCP_ENABLE', aNames[i]) then
    begin
      Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));
    end
    else
    begin
      LJM_NumberToIP(Cardinal(Trunc(aValues[i])), ipStr);
      Writeln('  ' + aNames[i] + ' = ' + ipStr + '  (' + FloatToStr(aValues[i]) + ')');
    end;
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
