{
  WriteWiFiConfig.dpr

  Demonstrates how to configure the WiFi settings on a LabJack.
}

program WriteWiFiConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 3;
  { Configuration names }
  aNames: array[0..2] of PAnsiChar = (
      'WIFI_IP_DEFAULT', 'WIFI_SUBNET_DEFAULT',
      'WIFI_GATEWAY_DEFAULT');
var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  value: Double;
  aValues: array[0..2] of Double;
  aValueStrs: array[0..2] of PAnsiChar = (
      '192.168.1.207', '255.255.255.0', { WIFI_IP_DEFAULT, WIFI_SUBNET_DEFAULT }
      '192.168.1.1');                   { WIFI_GATEWAY_DEFAULT }
  ssidStr: PAnsiChar = 'LJOpen'; { WIFI_SSID_DEFAULT }
  passwordStr: PAnsiChar = 'none'; { WIFI_PASSWORD_DEFAULT }
  valueUint: Cardinal;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Configure and write default WiFi configuration . }
  for i := 0 to 2 do
  begin
    LJM_IPToNumber(aValueStrs[i], valueUint);
    aValues[i] := valueUint;
  end;
  error := LJM_eWriteNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eWriteNames (configuration)', error, errorAddress);

  Writeln('Set WiFi Configuration:');
  for i := 0 to numFrames-1 do
    Writeln('  ' + aNames[i] + ' = ' + aValueStrs[i] + '  (' + FloatToStr(aValues[i]) + ')');

  { Configure the default WiFi SSID. }
  error := LJM_eWriteNameString(handle, 'WIFI_SSID_DEFAULT', ssidStr);
  ErrorHandler('LJM_eWriteNameString (SSID)', error);

  Writeln('  WIFI_SSID_DEFAULT: ' + ssidStr);

  { Configure the default WiFi password. }
  error := LJM_eWriteNameString(handle, 'WIFI_PASSWORD_DEFAULT', passwordStr);
  ErrorHandler('LJM_eWriteNameString (password)', error);

  Writeln('  WIFI_PASSWORD_DEFAULT: ' + passwordStr);

  { Apply the new WiFi configuration. }
  value := 1;
  error := LJM_eWriteName(handle, 'WIFI_APPLY_SETTINGS', value);
  ErrorHandler('LJM_eWriteName (apply)', error);

  Writeln('  WIFI_APPLY_SETTINGS: ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
