{
  eWriteAddress.dpr

  Demonstrates how to use the LJM_eWriteAddress function.
}

program eWriteAddress;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  address: Integer = 1000; { DAC0 }
  dataType: Integer = LJM_FLOAT32;
  value: Double = 2.5;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eWriteAddress to write a value to the LabJack. }
  { In this case we are setting address 1000 (DAC0) to 2.5 V. }
  error := LJM_eWriteAddress(handle, address, dataType, value);
  ErrorHandler('LJM_eWriteAddress', error);

  Writeln('LJM_eWriteAddress:');
  Writeln('  Address = ' + IntToStr(address) + ', value = ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
