{
  eWriteNames.dpr

  Demonstrates how to use the LJM_eWriteNames function.
}

program eWriteNames;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

const
  aNames: array[0..1] of PAnsiChar = ('DAC0', 'TEST_UINT16');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 2;
  aValues: array[0..1] of Double = (2.5, 12345);
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eWriteNames to write multiple values to the LabJack. }
  { In this case we are setting DAC0 and TEST_UINT16 to 2.5 V and 12345. }
  error := LJM_eWriteNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eWriteNames', error, errorAddress);

  Writeln('LJM_eWriteNames:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  Name = ' + aNames[i] + ' , value = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
