{******************************************************************************}
{                                                                              }
{  LJMDelphi.pas                                                               }
{                                                                              }
{  Delphi wrapper interface for the LJM library. Please refer to the           }
{  LabJackM.h header file and the LJM Library User's Guide for documentation   }
{  on function usage, constants and Modbus Map:                                }
{                                                                              }
{    http://labjack.com/support/ljm/users-guide                                }
{                                                                              }
{  Version History:                                                            }
{    1.0803 (06/18/2015)                                                       }
{      - Updated with LJM library v1.8.3 changes. Matching Delphi wrapper      }
{        version with the LJM version.                                         }
{    1.02 (12/30/2013)                                                         }
{      - Updated with LJM library v1.2 changes.                                }
{    1.01 (10/17/2013)                                                         }
{      - Updated with LJM library v1.1.1 changes.                              }
{    1.00 (09/04/2013)                                                         }
{      - Initial release. Tested with LJM library v0.2.46.                     }
{                                                                              }
{  Copyright (C) 2013 LabJack Corporation <support@labjack.com>                }
{                                                                              }
{  This software may be modified and distributed under the terms of the MIT    }
{  X11 license. See the LICENSE.txt file for details.                          }
{                                                                              }
{******************************************************************************}

unit LJMDelphi;

interface

{ Wrapper version }
const
  LJMDELPHI_VERSION = 1.0803;

{ LJM library Name }
const
  LJM_LIBRARY = 'LabJackM.dll';  {Windows dll}

{ Constants }
const
  { Read/Write direction constants }
  LJM_READ = 0;
  LJM_WRITE = 1;

  { Data Types }
  LJM_UINT16 = 0;
  LJM_UINT32 = 1;
  LJM_INT32 = 2;
  LJM_FLOAT32 = 3;

  { Advanced users data types }
  LJM_BYTE = 99;
  LJM_STRING = 98;

  LJM_STRING_MAX_SIZE = 49;

  LJM_STRING_ALLOCATION_SIZE = 50;

  LJM_INVALID_NAME_ADDRESS = -1;

  LJM_MAX_NAME_SIZE = 256;

  LJM_MAC_STRING_SIZE = 18;

  LJM_IPv4_STRING_SIZE = 16;

  { Device types }
  LJM_dtANY = 0;
  LJM_dtT7 = 7;
  LJM_dtDIGIT = 200;

  { Connection types }
  LJM_ctANY = 0;
  LJM_ctUSB = 1;
  LJM_ctTCP = 2;
  LJM_ctETHERNET = 3;
  LJM_ctWIFI = 4;

  { TCP/Ethernet constants }
  LJM_NO_IP_ADDRESS = 0;
  LJM_NO_PORT = 0;
  LJM_DEFAULT_PORT = 502;

  { Identifier types }
  LJM_DEMO_MODE = '-2';
  LJM_idANY = 0;

  { LJM_AddressesToMBFB Constants }
  LJM_DEFAULT_FEEDBACK_ALLOCATION_SIZE = 62;
  LJM_USE_DEFAULT_MAXBYTESPERMBFB = 0;

  { LJM_MBFBComm Constants }
  LJM_DEFAULT_UNIT_ID = 1;

  { LJM_ListAll Constants }
  LJM_LIST_ALL_SIZE = 128;

  LJM_MAX_USB_PACKET_NUM_BYTES = 64;
  LJM_MAX_TCP_PACKET_NUM_BYTES_T7 = 1040;
  LJM_MAX_ETHERNET_PACKET_NUM_BYTES_T7 = 1040;
  LJM_MAX_WIFI_PACKET_NUM_BYTES_T7 = 500;

  { Timeout Constants }
  LJM_NO_TIMEOUT = 0;
  LJM_DEFAULT_USB_SEND_RECEIVE_TIMEOUT_MS = 2600;
  LJM_DEFAULT_ETHERNET_OPEN_TIMEOUT_MS = 1000;
  LJM_DEFAULT_ETHERNET_SEND_RECEIVE_TIMEOUT_MS = 2600;
  LJM_DEFAULT_WIFI_OPEN_TIMEOUT_MS = 1000;
  LJM_DEFAULT_WIFI_SEND_RECEIVE_TIMEOUT_MS = 4000;

  { Stream Constants }
  LJM_DUMMY_VALUE = -9999;
  LJM_SCAN_NOT_READ = -8888;
  LJM_GND = 199;

  { Error Code Constants }
  LJME_NOERROR = 0;

  LJME_WARNINGS_BEGIN = 200;
  LJME_WARNINGS_END = 399;
  LJME_FRAMES_OMITTED_DUE_TO_PACKET_SIZE = 201;
  LJME_DEBUG_LOG_FAILURE = 202;
  LJME_USING_DEFAULT_CALIBRATION = 203;
  LJME_DEBUG_LOG_FILE_NOT_OPEN = 204;

  LJME_MODBUS_ERRORS_BEGIN = 1200;
  LJME_MODBUS_ERRORS_END = 1216;
  LJME_MBE1_ILLEGAL_FUNCTION = 1201;
  LJME_MBE2_ILLEGAL_DATA_ADDRESS = 1202;
  LJME_MBE3_ILLEGAL_DATA_VALUE = 1203;
  LJME_MBE4_SLAVE_DEVICE_FAILURE = 1204;
  LJME_MBE5_ACKNOWLEDGE = 1205;
  LJME_MBE6_SLAVE_DEVICE_BUSY = 1206;
  LJME_MBE8_MEMORY_PARITY_ERROR = 1208;
  LJME_MBE10_GATEWAY_PATH_UNAVAILABLE = 1210;
  LJME_MBE11_GATEWAY_TARGET_NO_RESPONSE = 1211;

  LJME_LIBRARY_ERRORS_BEGIN = 1220;
  LJME_LIBRARY_ERRORS_END = 1399;

  LJME_UNKNOWN_ERROR = 1221;
  LJME_INVALID_DEVICE_TYPE = 1222;
  LJME_INVALID_HANDLE = 1223;
  LJME_DEVICE_NOT_OPEN = 1224;
  LJME_STREAM_NOT_INITIALIZED = 1225;
  LJME_DEVICE_DISCONNECTED = 1226;
  LJME_DEVICE_NOT_FOUND = 1227;
  LJME_DEVICE_ALREADY_OPEN = 1229;
  LJME_COULD_NOT_CLAIM_DEVICE = 1230;
  LJME_CANNOT_CONNECT = 1231;
  LJME_SOCKET_LEVEL_ERROR = 1233;
  LJME_CANNOT_OPEN_DEVICE = 1236;
  LJME_CANNOT_DISCONNECT = 1237;
  LJME_WINSOCK_FAILURE = 1238;
  LJME_RECONNECT_FAILED = 1239;
  LJME_U3_CANNOT_BE_OPENED_BY_LJM = 1243;
  LJME_U6_CANNOT_BE_OPENED_BY_LJM = 1246;
  LJME_UE9_CANNOT_BE_OPENED_BY_LJM = 1249;
  LJME_INVALID_ADDRESS = 1250;
  LJME_INVALID_CONNECTION_TYPE = 1251;
  LJME_INVALID_DIRECTION = 1252;
  LJME_INVALID_FUNCTION = 1253;
  LJME_INVALID_NUM_REGISTERS = 1254;
  LJME_INVALID_PARAMETER = 1255;
  LJME_INVALID_PROTOCOL_ID = 1256;
  LJME_INVALID_TRANSACTION_ID = 1257;
  LJME_INVALID_VALUE_TYPE = 1259;
  LJME_MEMORY_ALLOCATION_FAILURE = 1260;
  LJME_NO_COMMAND_BYTES_SENT = 1261;
  LJME_INCORRECT_NUM_COMMAND_BYTES_SENT = 1262;
  LJME_NO_RESPONSE_BYTES_RECEIVED = 1263;
  LJME_INCORRECT_NUM_RESPONSE_BYTES_RECEIVED = 1264;
  LJME_MIXED_FORMAT_IP_ADDRESS = 1265;
  LJME_UNKNOWN_IDENTIFIER = 1266;
  LJME_NOT_IMPLEMENTED = 1267;
  LJME_INVALID_INDEX = 1268;
  LJME_INVALID_LENGTH = 1269;
  LJME_ERROR_BIT_SET = 1270;
  LJME_INVALID_MAXBYTESPERMBFB = 1271;
  LJME_NULL_POINTER = 1272;
  LJME_NULL_OBJ = 1273;
  LJME_RESERVED_NAME = 1274;
  LJME_UNPARSABLE_DEVICE_TYPE = 1275;
  LJME_UNPARSABLE_CONNECTION_TYPE = 1276;
  LJME_UNPARSABLE_IDENTIFIER = 1277;
  LJME_PACKET_SIZE_TOO_LARGE = 1278;
  LJME_TRANSACTION_ID_ERR = 1279;
  LJME_PROTOCOL_ID_ERR = 1280;
  LJME_LENGTH_ERR = 1281;
  LJME_UNIT_ID_ERR = 1282;
  LJME_FUNCTION_ERR = 1283;
  LJME_STARTING_REG_ERR = 1284;
  LJME_NUM_REGS_ERR = 1285;
  LJME_NUM_BYTES_ERR = 1286;
  LJME_CONFIG_FILE_NOT_FOUND = 1289;
  LJME_CONFIG_PARSING_ERROR = 1290;
  LJME_INVALID_NUM_VALUES = 1291;
  LJME_CONSTANTS_FILE_NOT_FOUND = 1292;
  LJME_INVALID_CONSTANTS_FILE = 1293;
  LJME_INVALID_NAME = 1294;
  LJME_OVERSPECIFIED_PORT = 1296;
  LJME_INTENT_NOT_READY = 1297;
  LJME_ATTR_LOAD_COMM_FAILURE = 1298;
  LJME_INVALID_CONFIG_NAME = 1299;
  LJME_ERROR_RETRIEVAL_FAILURE = 1300;
  LJME_LJM_BUFFER_FULL = 1301;
  LJME_COULD_NOT_START_STREAM = 1302;
  LJME_STREAM_NOT_RUNNING = 1303;
  LJME_UNABLE_TO_STOP_STREAM = 1304;
  LJME_INVALID_VALUE = 1305;
  LJME_SYNCHRONIZATION_TIMEOUT = 1306;
  LJME_OLD_FIRMWARE = 1307;
  LJME_CANNOT_READ_OUT_ONLY_STREAM = 1308;
  LJME_NO_SCANS_RETURNED = 1309;
  LJME_TEMPERATURE_OUT_OF_RANGE = 1310;
  LJME_VOLTAGE_OUT_OF_RANGE = 1311;

{ Device Management Functions }

function LJM_ListAll(DeviceType, ConnectionType: Integer; Var NumFound: Integer; aDeviceTypes, aConnectionTypes, aSerialNumbers, aIPAddresses: PInteger): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_ListAllS(Const DeviceType, ConnectionType: PAnsiChar; Var NumFound: Integer; aDeviceTypes, aConnectionTypes, aSerialNumbers, aIPAddresses: PInteger): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_ListAllExtended(DeviceType, ConnectionType, NumAddresses: Integer; Const aAddresses, aNumRegs: PInteger; MaxNumFound: Integer; Var NumFound: Integer; aDeviceTypes, aConnectionTypes, aSerialNumbers, aIPAddresses: PInteger; aBytes: PByte): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_OpenS(Const DeviceType, ConnectionType, Identifier: PAnsiChar; Var Handle: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_Open(DeviceType, ConnectionType: Integer; Const Identifier: PAnsiChar; Var Handle: Integer): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_GetHandleInfo(Handle: Integer; Var DeviceType, ConnectionType, SerialNumber, IPAddress, Port, MaxBytesPerMB: Integer): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_Close(Handle: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_CloseAll: Integer;
  stdcall; external LJM_LIBRARY;

{ Easy Functions }

{ Renamed Type parameter to DataType. }
function LJM_eWriteAddress(Handle, Address, DataType: Integer; Value: Double): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed Type parameter to DataType. }
function LJM_eReadAddress(Handle, Address, DataType: Integer; Var Value: Double): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_eWriteName(Handle: Integer; Const Name: PAnsiChar; Value: Double): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eReadName(Handle: Integer; Const Name: PAnsiChar; Var Value: Double): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed aTypes parameter to aDataTypes. }
function LJM_eReadAddresses(Handle, NumFrames: Integer; Const aAddresses, aDataTypes: PInteger;	aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eReadNames(Handle, NumFrames: Integer; Const aNames: PPAnsiChar; aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed aTypes parameter to aDataTypes. }
function LJM_eWriteAddresses(Handle, NumFrames: Integer; Const aAddresses, aDataTypes: PInteger; Const aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eWriteNames(Handle, NumFrames: Integer; Const aNames: PPAnsiChar; Const aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed Type parameter to DataType. }
function LJM_eReadAddressArray(Handle, Address, DataType, NumValues: Integer; aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eReadNameArray(Handle: Integer; Const Name: PAnsiChar; NumValues: Integer; aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed Type parameter to DataType. }
function LJM_eWriteAddressArray(Handle, Address, DataType, NumValues: Integer; Const aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eWriteNameArray(Handle: Integer; Const Name: PAnsiChar; NumValues: Integer; Const aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed aTypes parameter to aDataTypes. }
function LJM_eAddresses(Handle, NumFrames: Integer; Const aAddresses, aDataTypes, aWrites, aNumValues: PInteger; aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eNames(Handle, NumFrames: Integer; Const aNames: PPAnsiChar; Const aWrites, aNumValues: PInteger; aValues: PDouble; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed String parameter to ReadString. }
function LJM_eReadNameString(Handle: Integer; Const Name: PAnsiChar; ReadString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed String parameter to ReadString. }
function LJM_eReadAddressString(Handle, Address: Integer; ReadString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed String parameter to WriteString. }
function LJM_eWriteNameString(Handle: Integer; Const Name, WriteString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed String parameter to WriteString. }
function LJM_eWriteAddressString(Handle, Address: Integer; Const WriteString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;

{  Stream Functions }

function LJM_eStreamStart(Handle, ScansPerRead, NumAddresses: Integer; Const aScanList: PInteger; Var ScanRate: Double): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eStreamRead(Handle: Integer; aData: PDouble; Var DeviceScanBacklog, LJMScanBacklog: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_eStreamStop(Handle: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Byte-oriented Read/Write Functions }

function LJM_WriteRaw(Handle: Integer; Const Data: PByte; NumBytes: Integer): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_ReadRaw(Handle: Integer; Data: PByte; NumBytes: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed aTypes parameter to aDataTypes. }
function LJM_AddressesToMBFB(MaxBytesPerMBFB: Integer; Const aAddresses, aDataTypes, aWrites, aNumValues: PInteger; Const aValues: PDouble; Var NumFrames: Integer; aMBFBCommand: PByte): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_MBFBComm(Handle: Integer; UnitID: Byte; aMBFB: PByte; Var ErrorAddress: Integer): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed aTypes parameter to aDataTypes. }
function LJM_UpdateValues(aMBFBResponse: PByte; Const aDataTypes, aWrites, aNumValues: PInteger; NumFrames: Integer; aValues: PDouble): Integer;
  stdcall; external LJM_LIBRARY;

{ Constants File Functions }

{ Renamed aTypes parameter to aDataTypes. }
function LJM_NamesToAddresses(NumFrames: Integer; Const aNames: PPAnsiChar; aAddresses, aDataTypes: PInteger): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed Type parameter to DataType. }
function LJM_NameToAddress(Const Name: PAnsiChar; Var Address, DataType: Integer): Integer;
  stdcall; external LJM_LIBRARY;

{ Renamed aTypes parameter to aDataTypes. }
function LJM_AddressesToTypes(NumAddresses: Integer; aAddresses, aDataTypes: PInteger): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed Type parameter to DataType. }
function LJM_AddressToType(Address: Integer; Var DataType: Integer): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_LookupConstantValue(Const Scope, ConstantName: PAnsiChar; Var ConstantValue: Double): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_LookupConstantName(Const Scope: PAnsiChar; ConstantValue: Double; ConstantName: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;

procedure LJM_ErrorToString(ErrorCode: Integer; ErrorString: PAnsiChar);
  stdcall; external LJM_LIBRARY;

procedure LJM_LoadConstants;
  stdcall; external LJM_LIBRARY;
function LJM_LoadConstantsFromFile(Const FileName: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_LoadConstantsFromString(Const JsonString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;


{ Type Conversion Functions }

{ Thermocouple Type Constants }
const
  LJM_ttB = 6001;
  LJM_ttE = 6002;
  LJM_ttJ = 6003;
  LJM_ttK = 6004;
  LJM_ttN = 6005;
  LJM_ttR = 6006;
  LJM_ttS = 6007;
  LJM_ttT = 6008;
  LJM_ttC = 6009;
  
function LJM_TCVoltsToTemp(TCType: Integer; TCVolts, CJTempK: Double; Var pTCTempK: Double): Integer;
  stdcall; external LJM_LIBRARY;

procedure LJM_FLOAT32ToByteArray(Const aFLOAT32: PSingle; RegisterOffset, NumFLOAT32: Integer; aBytes: PByte);
  stdcall; external LJM_LIBRARY;
procedure LJM_ByteArrayToFLOAT32(Const aBytes: PByte; RegisterOffset, NumFLOAT32: Integer; aFLOAT32: PSingle);
  stdcall; external LJM_LIBRARY;

procedure LJM_UINT16ToByteArray(Const aUINT16: PWord; RegisterOffset, NumUINT16: Integer; aBytes: PByte);
  stdcall; external LJM_LIBRARY;
procedure LJM_ByteArrayToUINT16(Const aBytes: PByte; RegisterOffset, NumUINT16: Integer; aUINT16: PWord);
  stdcall; external LJM_LIBRARY;

procedure LJM_UINT32ToByteArray(Const aUINT32: PCardinal; RegisterOffset, NumUINT32: Integer; aBytes: PByte);
  stdcall; external LJM_LIBRARY;
procedure LJM_ByteArrayToUINT32(Const aBytes: PByte; RegisterOffset, NumUINT32: Integer; aUINT32: PCardinal);
  stdcall; external LJM_LIBRARY;

procedure LJM_INT32ToByteArray(Const aINT32: PInteger; RegisterOffset, NumINT32: Integer; aBytes: PByte);
  stdcall; external LJM_LIBRARY;
procedure LJM_ByteArrayToINT32(Const aBytes: PByte; RegisterOffset, NumINT32: Integer; aINT32: PInteger);
  stdcall; external LJM_LIBRARY;

function LJM_NumberToIP(Number: Cardinal; IPv4String: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_IPToNumber(Const IPv4String: PAnsiChar; Var Number: Cardinal): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_NumberToMAC(Number: Uint64; MACString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_MACToNumber(Const MACString: PAnsiChar; Var Number: Uint64): Integer;
  stdcall; external LJM_LIBRARY;

{ LJM Configuration }

{ Configuration constants and strings }
const
  LJM_USB_SEND_RECEIVE_TIMEOUT_MS = 'LJM_USB_SEND_RECEIVE_TIMEOUT_MS';
  LJM_ETHERNET_SEND_RECEIVE_TIMEOUT_MS = 'LJM_ETHERNET_SEND_RECEIVE_TIMEOUT_MS';
  LJM_WIFI_SEND_RECEIVE_TIMEOUT_MS = 'LJM_WIFI_SEND_RECEIVE_TIMEOUT_MS';
  LJM_SEND_RECEIVE_TIMEOUT_MS = 'LJM_SEND_RECEIVE_TIMEOUT_MS';
  LJM_ETHERNET_OPEN_TIMEOUT_MS = 'LJM_ETHERNET_OPEN_TIMEOUT_MS';
  LJM_WIFI_OPEN_TIMEOUT_MS = 'LJM_WIFI_OPEN_TIMEOUT_MS';
  LJM_OPEN_TCP_DEVICE_TIMEOUT_MS = 'LJM_OPEN_TCP_DEVICE_TIMEOUT_MS';
  LJM_DEBUG_LOG_MODE = 'LJM_DEBUG_LOG_MODE';
	  LJM_DEBUG_LOG_MODE_NEVER = 1.0;
	  LJM_DEBUG_LOG_MODE_CONTINUOUS = 2.0;
	  LJM_DEBUG_LOG_MODE_ON_ERROR = 3.0;
  LJM_DEBUG_LOG_LEVEL = 'LJM_DEBUG_LOG_LEVEL';
    LJM_STREAM_PACKET = 1.0;
    LJM_TRACE = 2.0;
    LJM_DEBUG = 4.0;
    LJM_INFO = 6.0;
    LJM_PACKET = 7.0;
    LJM_WARNING = 8.0;
    LJM_ERROR = 10.0;
    LJM_FATAL = 12.0;
  LJM_DEBUG_LOG_BUFFER_MAX_SIZE = 'LJM_DEBUG_LOG_BUFFER_MAX_SIZE';
  LJM_DEBUG_LOG_SLEEP_TIME_MS = 'LJM_DEBUG_LOG_SLEEP_TIME_MS';
  LJM_LIBRARY_VERSION = 'LJM_LIBRARY_VERSION';
  LJM_ALLOWS_AUTO_MULTIPLE_FEEDBACKS = 'LJM_ALLOWS_AUTO_MULTIPLE_FEEDBACKS';
  LJM_ALLOWS_AUTO_CONDENSE_ADDRESSES = 'LJM_ALLOWS_AUTO_CONDENSE_ADDRESSES';
  LJM_AUTO_RECONNECT_STICKY_CONNECTION = 'LJM_AUTO_RECONNECT_STICKY_CONNECTION';
  LJM_AUTO_RECONNECT_STICKY_SERIAL = 'LJM_AUTO_RECONNECT_STICKY_SERIAL';
  LJM_OPEN_MODE = 'LJM_OPEN_MODE';
    LJM_KEEP_OPEN = 1.0;
    LJM_OPEN_CLOSE = 2.0;
  LJM_MODBUS_MAP_CONSTANTS_FILE = 'LJM_MODBUS_MAP_CONSTANTS_FILE';
  LJM_ERROR_CONSTANTS_FILE = 'LJM_ERROR_CONSTANTS_FILE';
  LJM_DEBUG_LOG_FILE = 'LJM_DEBUG_LOG_FILE';
  LJM_CONSTANTS_FILE = 'LJM_CONSTANTS_FILE';
  LJM_DEBUG_LOG_FILE_MAX_SIZE = 'LJM_DEBUG_LOG_FILE_MAX_SIZE';
  LJM_STREAM_SCANS_RETURN = 'LJM_STREAM_SCANS_RETURN';
	  LJM_STREAM_SCANS_RETURN_ALL = 1.0;
	  LJM_STREAM_SCANS_RETURN_ALL_OR_NONE = 2.0;
  LJM_STREAM_RECEIVE_TIMEOUT_MODE = 'LJM_STREAM_RECEIVE_TIMEOUT_MODE';
  	LJM_STREAM_RECEIVE_TIMEOUT_MODE_CALCULATED = 1.0;
	  LJM_STREAM_RECEIVE_TIMEOUT_MODE_MANUAL = 2.0;
  LJM_STREAM_RECEIVE_TIMEOUT_MS = 'LJM_STREAM_RECEIVE_TIMEOUT_MS';
  LJM_STREAM_TRANSFERS_PER_SECOND = 'LJM_STREAM_TRANSFERS_PER_SECOND';
  LJM_RETRY_ON_TRANSACTION_ID_MISMATCH = 'LJM_RETRY_ON_TRANSACTION_ID_MISMATCH';
  LJM_OLD_FIRMWARE_CHECK = 'LJM_OLD_FIRMWARE_CHECK';
  LJM_ZERO_LENGTH_ARRAY_MODE = 'LJM_ZERO_LENGTH_ARRAY_MODE';
  	LJM_ZERO_LENGTH_ARRAY_ERROR = 1.0;
	  LJM_ZERO_LENGTH_ARRAY_IGNORE_OPERATION = 2.0;

{ Configuration functions }

function LJM_WriteLibraryConfigS(Const Parameter: PAnsiChar; Value: Double): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed String parameter to ConfigString. }
function LJM_WriteLibraryConfigStringS(Const Parameter, ConfigString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_ReadLibraryConfigS(Const Parameter: PAnsiChar; Var Value: Double): Integer;
  stdcall; external LJM_LIBRARY;
{ Renamed String parameter to ConfigString. }
function LJM_ReadLibraryConfigStringS(Const Parameter: PAnsiChar; ConfigString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;

function LJM_LoadConfigurationFile(Const FileName: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;

{ Log Functions }

{ Renamed String parameter to MessageString. }
function LJM_Log(Level: Integer; MessageString: PAnsiChar): Integer;
  stdcall; external LJM_LIBRARY;
function LJM_ResetLog: Integer;
  stdcall; external LJM_LIBRARY;

implementation

end.
