{
  SingleAINWithConfig.dpr

  Demonstrates configuring and reading a single analog input (AIN) with a LabJack.
}

program SingleAINWithConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFramesW: Integer = 3; { Configuration frames }
  aNamesW: array[0..2] of PAnsiChar = ('AIN0_NEGATIVE_CH', 'AIN0_RANGE', 'AIN0_RESOLUTION_INDEX'); { Configuration names. }
  nameR: PAnsiChar = 'AIN0'; { Reading name. }
var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  aValuesW: array[0..2] of Double = ( 199, 10, 0 );  { Configuration values }
  valueR: Double = 0; { Reading value }
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Configuring AIN0_NEGATIVE_CH to 199, AIN0_RANGE to 10 , and }
  { AIN0_RESOLUTION_INDEX to 0. }
  error := LJM_eWriteNames(handle, numFramesW, @aNamesW, @aValuesW, errorAddress);
  ErrorHandler('LJM_eWriteNames (Configuration)', error, errorAddress);

  Writeln('Configuration:');
  for i := 0 to numFramesW-1 do
  begin
    Writeln('  ' + aNamesW[i] + ' = ' + FloatToStr(aValuesW[i]));
  end;

  { Reading AIN0. }
  error := LJM_eReadName(handle, nameR, valueR);
  ErrorHandler('LJM_eReadName (Reading)', error);

  Writeln('');
  Writeln(nameR + ' reading = ' + FormatFloat('0.00000', valueR) + ' V');

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
