{
  WritePowerConfig.dpr

  Demonstrates how to configure default power settings on a LabJack.
}

program WritePowerConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 4;
  { Configuration names }
  aNames: array[0..3] of PAnsiChar = (
        'POWER_ETHERNET_DEFAULT', 'POWER_WIFI_DEFAULT', 'POWER_AIN_DEFAULT',
        'POWER_LED_DEFAULT');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  aValues: array[0..3] of Double = (
        1, 0, 1,
        1);
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Set the configuration }
  error := LJM_eWriteNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eWriteNames', error, errorAddress);

  Writeln('Set Configuration:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
