{
  SingleDIORead.dpr

  Demonstrates how to read a single digital input/output.
}

program SingleDIORead;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  name: PAnsiChar = 'FIO0';

var
  handle: Integer;
  error: Integer = 0;
  value: Double = 0.0;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Read FIO0 state }
  error := LJM_eReadName(handle, name, value);
  ErrorHandler('LJM_eReadName', error);

  Writeln(name + ' state = ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
