{
  SingleDIOWrite.dpr

  Demonstrates how to set a single digital state on a LabJack.
}

program SingleDIOWrite;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  name: PAnsiChar = 'FIO0';

var
  handle: Integer;
  error: Integer = 0;
  value: Double = 0; { 0 = low, 1 = high }
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Set FIO0 to output-low }
  error := LJM_eWriteName(handle, name, value);
  ErrorHandler('LJM_eWriteName', error);

  Writeln('Set ' + name + ' state to ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
