{
  ReadEthernetMAC.dpr

  Demonstrates how to read the ethernet MAC from a LabJack.
}

program ReadEthernetMAC;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 1;
  aAddresses: array[0..0] of Integer = ( 60020 ); { ETHERNET_MAC }
  aDataTypes: array[0..0] of Integer = ( LJM_BYTE );
  aWrites: array[0..0] of Integer = (LJM_READ);
  aNumValues: array[0..0] of Integer = (8); { Indicates the number of bytes to read }
  aValues: array[0..7] of Double;
  MACInt: Int64 = 0;
  MACStr: array[0..LJM_MAC_STRING_SIZE-1] of AnsiChar;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call eAddresses to read the ethernet MAC. We are reading a byte array which
  { is the big endian binary representation of the 64-bit MAC. }
  error := LJM_eAddresses(handle, numFrames, @aAddresses, @aDataTypes, @aWrites, @aNumValues, @aValues, errorAddress);
  ErrorHandler('LJM_eAddresses', error, errorAddress);

  { Convert returned array a 64-bit integer. }
  for i := 0 to 7 do
    MACInt := MACInt + Int64(Trunc(aValues[i])) shl ((7-i)*8);

  LJM_NumberToMAC(Uint64(MACInt), @MACStr);
  Writeln('Read Ethernet MAC = ' + MACStr + '  (' + IntToStr(MACInt) + ')' );

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
