{
  WriteEthernetConfig.dpr

  Demonstrates how to set ethernet configuration settings on a LabJack.
}

program WriteEthernetConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 4;
  { Configuration names }
  aNames: array[0..3] of PAnsiChar = (
      'ETHERNET_IP_DEFAULT', 'ETHERNET_SUBNET_DEFAULT',
      'ETHERNET_GATEWAY_DEFAULT', 'ETHERNET_DHCP_ENABLE_DEFAULT');
var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  aValues: array[0..3] of Double;
  aValueStrs: array[0..2] of PAnsiChar = (
      '192.168.1.175', '255.255.255.0', { ETHERNET_IP_DEFAULT, ETHERNET_SUBNET_DEFAULT }
      '192.168.1.1');                   { ETHERNET_GATEWAY_DEFAULT }
  valueUint: Cardinal;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Configure and write ethernet configuration settings. }
  for i := 0 to 2 do
  begin
    LJM_IPToNumber(aValueStrs[i], valueUint);
    aValues[i] := valueUint;
  end;
  aValues[3] := 1; { ETHERNET_DHCP_ENABLE_DEFAULT }
  error := LJM_eWriteNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eWriteNames', error, errorAddress);

  Writeln('Set Ethernet Configuration:');
  for i := 0 to 2 do
    Writeln('  ' + aNames[i] + ' = ' + aValueStrs[i] + '  (' + FloatToStr(aValues[i]) + ')');
  Writeln('  ' + aNames[3] + ' = ' + FloatToStr(aValues[3]));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
