{
  ReadWatchdogConfig.dpr

  Demonstrates how to read the Watchdog configuration from a LabJack.
}

program ReadWatchdogConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 15;
  { Configuration names }
  aNames: array[0..14] of PAnsiChar = (
      'WATCHDOG_ENABLE_DEFAULT', 'WATCHDOG_ADVANCED_DEFAULT',
      'WATCHDOG_TIMEOUT_S_DEFAULT', 'WATCHDOG_STARTUP_DELAY_S_DEFAULT',
      'WATCHDOG_STRICT_ENABLE_DEFAULT', 'WATCHDOG_STRICT_KEY_DEFAULT',
      'WATCHDOG_RESET_ENABLE_DEFAULT', 'WATCHDOG_DIO_ENABLE_DEFAULT',
      'WATCHDOG_DIO_STATE_DEFAULT', 'WATCHDOG_DIO_DIRECTION_DEFAULT',
      'WATCHDOG_DIO_INHIBIT_DEFAULT', 'WATCHDOG_DAC0_ENABLE_DEFAULT',
      'WATCHDOG_DAC0_DEFAULT', 'WATCHDOG_DAC1_ENABLE_DEFAULT',
      'WATCHDOG_DAC1_DEFAULT');
var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  aValues: array[0..14] of Double;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtANY, LJM_ctANY, 'ANY', handle);
  //error := LJM_OpenS('ANY', 'ANY', 'ANY', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Read the Watchdog configuration. }
  error := LJM_eReadNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eReadNames', error, errorAddress);

  Writeln('Read Watchdog Configuration:');
  for i := 0 to numFrames-1 do
    Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
