{
  ReadWiFiConfig.dpr

  Demonstrates how to read the WiFi configuration from a LabJack.
}

program ReadWiFiConfig;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  StrUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

const
  numFrames: Integer = 9;
  { Configuration names }
  aNames: array[0..8] of PAnsiChar = (
      'WIFI_IP', 'WIFI_SUBNET', 'WIFI_GATEWAY',
      'WIFI_DHCP_ENABLE', 'WIFI_IP_DEFAULT', 'WIFI_SUBNET_DEFAULT',
      'WIFI_GATEWAY_DEFAULT', 'WIFI_DHCP_ENABLE_DEFAULT', 'WIFI_STATUS');

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  { Configuration values }
  aValues: array[0..8] of Double;
  ipStr: array[0..LJM_IPv4_STRING_SIZE-1] of AnsiChar;
  readString: array[0..LJM_STRING_ALLOCATION_SIZE-1] of AnsiChar; 
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Read WiFi configuration settings }
  error := LJM_eReadNames(handle, numFrames, @aNames, @aValues, errorAddress);
  ErrorHandler('LJM_eReadNames', error, errorAddress);

  Writeln('Read WiFi Configuration:');
  for i := 0 to numFrames-1 do
  begin
    if (AnsiStartsStr('WIFI_STATUS', aNames[i])) or (AnsiStartsStr('WIFI_DHCP_ENABLE', aNames[i])) then
    begin
      Writeln('  ' + aNames[i] + ' = ' + FloatToStr(aValues[i]));
    end
    else
    begin
      LJM_NumberToIP(Cardinal(Trunc(aValues[i])), ipStr);
      Writeln('  ' + aNames[i] + ' = ' + ipStr + '  (' + FloatToStr(aValues[i]) + ')');
    end;
  end;

  { Read WiFi SSID string from the LabJack }
  error := LJM_eReadNameString(handle, 'WIFI_SSID', readString);
  ErrorHandler('LJM_eReadNameString', error);

  Writeln('  WIFI_SSID: ' + readString);

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
