{
  eAddresses.dpr

  Demonstrates how to use the LJM_eAddresses function.
}

program eAddresses;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 3;
  aAddresses: array[0..2] of Integer = ( 1000, 55110, 55110 ); { DAC0, TEST_UINT16, TEST_UINT16 }
  aDataTypes: array[0..2] of Integer = ( LJM_FLOAT32, LJM_UINT16, LJM_UINT16 );
  aWrites: array[0..2] of Integer = (LJM_WRITE, LJM_WRITE, LJM_READ);
  aNumValues: array[0..2] of Integer = (1, 1, 1);
  aValues: array[0..2] of Double = (2.5, 12345, 0);
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eAddresses to write/read multiple values to/from the LabJack. }
  { In this case we are setting addresses 1000 (DAC0) and 55110 (TEST_UINT16) }
  { to 2.5 V and 12345, and reading 55110 (TEST_UINT16). }
  error := LJM_eAddresses(handle, numFrames, @aAddresses, @aDataTypes, @aWrites, @aNumValues, @aValues, errorAddress);
  ErrorHandler('LJM_eAddresses', error, errorAddress);

  Writeln('LJM_eAddresses:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  Address = ' + IntToStr(aAddresses[i]) + ' , write = ' + IntToStr(aWrites[i]) + ', value = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
