{
  eReadAddress.dpr

  Demonstrates how to use the LJM_eWriteAddress function.
}

program eReadAddress;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  address: Integer = 60028; { SERIAL_NUMBER }
  dataType: Integer = LJM_UINT32;
  value: Double = 0;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eReadAddress to read a value from the LabJack. }
  { In this case we are reading address 60028 (SERIAL_NUMBER). }
  error := LJM_eReadAddress(handle, address, dataType, value);
  ErrorHandler('LJM_eReadAddress', error);

  Writeln('LJM_eReadAddress:');
  Writeln('  Address = ' + IntToStr(address) + ', value = ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
