{
  eReadAddresses.dpr

  Demonstrates how to use the LJM_eReadAddresses function.
}

program eReadAddresses;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 3;
  aAddresses: array[0..2] of Integer = ( 60028, 60000, 60004 ); { SERIAL_NUMBER, PRODUCT_ID, FIRMWARE_VERSION }
  aDataTypes: array[0..2] of Integer = ( LJM_UINT32, LJM_FLOAT32, LJM_FLOAT32 );
  aValues: array[0..2] of Double = (0, 0, 0);
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eReadAddresses to read multiple values from the LabJack. }
  { In this case we are reading addresses 60028 (SERIAL_NUMBER), 60000 (PRODUCT_ID) }
  { 60004 (FIRMWARE_VERSION). }
  error := LJM_eReadAddresses(handle, numFrames, @aAddresses, @aDataTypes, @aValues, errorAddress);
  ErrorHandler('LJM_eReadAddresses', error, errorAddress);

  Writeln('LJM_eReadAddresses:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  Address = ' + IntToStr(aAddresses[i]) + ', value = ' + FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
