{
  eReadName.dpr

  Demonstrates how to use the LJM_eReadName function.
}

program eReadName;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

const
  name: PAnsiChar = 'SERIAL_NUMBER';

var
  handle: Integer;
  error: Integer = 0;
  value: Double = 0.0;
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eReadName to read a value from the LabJack. }
  { In this case we are reading the serial number. }
  error := LJM_eReadName(handle, name, value);
  ErrorHandler('LJM_eReadName', error);

  Writeln('LJM_eReadName:');
  Writeln('  Name = ' + name + ' , read value = ' + FloatToStr(value));

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
