{
  eWriteAddresses.dpr

  Demonstrates how to use the LJM_eWriteAddresses function.
}

program eWriteAddresses;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\Wrapper\LJMDelphi.pas',
  LJMUtilities in 'LJMUtilities.pas';

var
  i: Integer;
  handle: Integer;
  error: Integer = 0;
  errorAddress: Integer = -1;
  numFrames: Integer = 2;
  aAddresses: array[0..1] of Integer = ( 1000, 55110); { DAC0, TEST_UINT16 }
  aDataTypes: array[0..1] of Integer = ( LJM_FLOAT32, LJM_UINT16 );
  aValues: array[0..1] of Double = ( 2.5, 12345 );
begin
  { Open first found LabJack. }
  error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', handle);
  //error := LJM_OpenS('Any', 'Any', 'Any', handle);
  ErrorHandler('LJM_Open', error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(handle);

  { Call LJM_eWriteAddresses to write multiple values to the LabJack. }
  { In this case we are setting addresses 1000 (DAC0) and 55110 (TEST_UINT16) }
  { to 2.5 V and 12345. }
  error := LJM_eWriteAddresses(handle, numFrames, @aAddresses, @aDataTypes, @aValues, errorAddress);
  ErrorHandler('LJM_eWriteAddresses', error, errorAddress);

  Writeln('LJM_eWriteAddresses:');
  for i := 0 to numFrames-1 do
  begin
    Writeln('  Address = ' + IntToStr(aAddresses[i]) + ', value = ' + FormatFloat('0.####', aValues[i]));
  end;

  { Close the handle. }
  error := LJM_Close(handle);
  ErrorHandler('LJM_Close', error);

  WaitForUser('Press Enter to exit.');
end.
