{******************************************************************************}
{                                                                              }
{  eAddresses.dpr                                                              }
{                                                                              }
{  Demonstrates how to use the LJM_eAddresses function.                        }
{                                                                              }
{******************************************************************************}

program eAddresses;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  NumFrames: Integer;
  aAddresses: array [0..2] of Integer;
  aDataTypes: array [0..2] of Integer;
  aWrites: array [0..2] of Integer;
  aNumValues: array [0..2] of Integer;
  aValues: array [0..2] of Double;
  ErrorAddress: Integer;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eAddresses to write and read multiple values to and from the
    LabJack. }
  NumFrames := 3;
  aAddresses[0] := 1000; { DAC0 }
  aAddresses[1] := 55110; { TEST_UINT16 }
  aAddresses[2] := 55110; { TEST_UINT16 }
  aDataTypes[0] := LJM_FLOAT32;
  aDataTypes[1] := LJM_UINT16;
  aDataTypes[2] := LJM_UINT16;
  aWrites[0] := LJM_WRITE;
  aWrites[1] := LJM_WRITE;
  aWrites[2] := LJM_READ;
  aNumValues[0] := 1;
  aNumValues[1] := 1;
  aNumValues[2] := 1;
  aValues[0] := 2.5; { volts }
  aValues[1] := 12345;
  aValues[2] := 0;
  ErrorAddress := -1;
  Error := LJM_eAddresses(Handle, NumFrames, @aAddresses, @aDataTypes, @aWrites,
    @aNumValues, @aValues, ErrorAddress);
  ErrorHandler('LJM_eAddresses', Error, ErrorAddress);

  Writeln('LJM_eAddresses:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  Address = ' + IntToStr(aAddresses[i]) + ' , write = ' +
      IntToStr(aWrites[i]) + ', value = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
