{******************************************************************************}
{                                                                              }
{  eNames.dpr                                                                  }
{                                                                              }
{  Demonstrates how to use the LJM_eNames function.                            }
{                                                                              }
{******************************************************************************}

program eNames;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  i: Integer;
  Handle: Integer;
  Error: Integer;
  ErrorAddress: Integer;
  NumFrames: Integer;
  aNames: array [0..2] of AnsiString;
  aWrites: array [0..2] of Integer;
  aNumValues: array [0..2] of Integer;
  aValues: array [0..2] of Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eNames to write/read multiple values to/from the LabJack. }
  NumFrames := 3;
  aNames[0] := 'DAC0';
  aNames[1] := 'TEST_UINT16';
  aNames[2] := 'TEST_UINT16';
  aWrites[0] := LJM_WRITE;
  aWrites[1] := LJM_WRITE;
  aWrites[2] := LJM_READ;
  aNumValues[0] := 1;
  aNumValues[1] := 1;
  aNumValues[2] := 1;
  aValues[0] := 2.5;
  aValues[1] := 12345;
  aValues[2] := 0;
  ErrorAddress := -1;
  Error := LJM_eNames(Handle, NumFrames, @aNames, @aWrites, @aNumValues,
    @aValues, ErrorAddress);
  ErrorHandler('LJM_eNames', Error, ErrorAddress);

  Writeln('LJM_eNames:');
  for i := 0 to NumFrames-1 do
  begin
    Writeln('  Name = ' + aNames[i] + ' , Write = ' + IntToStr(aWrites[i]) +
      ', Value = ' + FloatToStr(aValues[i]));
  end;

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
