{******************************************************************************}
{                                                                              }
{ eReadName.dpr                                                                }
{                                                                              }
{ Demonstrates how to use the LJM_eReadName function.                          }
{                                                                              }
{******************************************************************************}

program eReadName;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  Name: AnsiString;
  Value: Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eReadName to read a value from the LabJack. }
  Name := 'SERIAL_NUMBER';
  Value := 0;
  Error := LJM_eReadName(Handle, PAnsiChar(Name), Value);
  ErrorHandler('LJM_eReadName', Error);

  Writeln('LJM_eReadName:');
  Writeln('  Name = ' + Name + ' , Value = ' + FloatToStr(Value));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
