{******************************************************************************}
{                                                                              }
{  eWriteAddress.dpr                                                           }
{                                                                              }
{  Demonstrates how to use the LJM_eWriteAddress function.                     }
{                                                                              }
{******************************************************************************}

program eWriteAddress;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  LJMDelphi in '..\..\Wrapper\LJMDelphi.pas',
  LJMUtilities in '..\LJMUtilities.pas';

var
  Handle: Integer;
  Error: Integer;
  Address: Integer;
  DataType: Integer;
  Value: Double;
begin
  Handle := 0;

  { Open first found LabJack }

  { Any device, Any connection, Any identifier }
  Error := LJM_OpenS('Any', 'Any', 'Any', Handle);

  { T7 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T7', 'Any', 'Any', Handle); }

  { T4 device, Any connection, Any identifier }
  { Error := LJM_OpenS('T4', 'Any', 'Any', Handle); }

  { Any device, Any connection, Any identifier }
  { Error := LJM_Open(LJM_dtAny, LJM_ctAny, 'Any', Handle); }

  ErrorHandler('LJM_OpenS', Error);

  { Display opened device's information. }
  PrintDeviceInfoFromHandle(Handle);

  { Call LJM_eWriteAddress to write a value to the LabJack. }
  Address := 1000; { DAC0 }
  DataType := LJM_FLOAT32;
  Value := 2.5; { V }
  Error := LJM_eWriteAddress(Handle, Address, DataType, Value);
  ErrorHandler('LJM_eWriteAddress', Error);

  Writeln('LJM_eWriteAddress:');
  Writeln('  Address = ' + IntToStr(Address) + ', Value = ' +
    FloatToStr(Value));

  { Close the handle. }
  Error := LJM_Close(Handle);
  ErrorHandler('LJM_Close', Error);

  WaitForUser('Press Enter to exit.');
end.
